<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retry ServiceType
 * @subpackage Services
 */
class Retry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetryContactProvisioning
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetryContactProvisioning $parameters
     * @return \StructType\RetryContactProvisioningResponse|bool
     */
    public function RetryContactProvisioning(\StructType\RetryContactProvisioning $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetryContactProvisioning($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetryGroupProvisioning
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetryGroupProvisioning $parameters
     * @return \StructType\RetryGroupProvisioningResponse|bool
     */
    public function RetryGroupProvisioning(\StructType\RetryGroupProvisioning $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetryGroupProvisioning($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetryUserProvisioning
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetryUserProvisioning $parameters
     * @return \StructType\RetryUserProvisioningResponse|bool
     */
    public function RetryUserProvisioning(\StructType\RetryUserProvisioning $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetryUserProvisioning($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetryContactProvisioningResponse|\StructType\RetryGroupProvisioningResponse|\StructType\RetryUserProvisioningResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
