<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reset ServiceType
 * @subpackage Services
 */
class Reset extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ResetUserPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserPassword $parameters
     * @return \StructType\ResetUserPasswordResponse|bool
     */
    public function ResetUserPassword(\StructType\ResetUserPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ResetUserPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ResetUserPasswordByUpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserPasswordByUpn $parameters
     * @return \StructType\ResetUserPasswordByUpnResponse|bool
     */
    public function ResetUserPasswordByUpn(\StructType\ResetUserPasswordByUpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ResetUserPasswordByUpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ResetStrongAuthenticationMethodByUpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetStrongAuthenticationMethodByUpn $parameters
     * @return \StructType\ResetStrongAuthenticationMethodByUpnResponse|bool
     */
    public function ResetStrongAuthenticationMethodByUpn(\StructType\ResetStrongAuthenticationMethodByUpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ResetStrongAuthenticationMethodByUpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResetStrongAuthenticationMethodByUpnResponse|\StructType\ResetUserPasswordByUpnResponse|\StructType\ResetUserPasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
