<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Navigate ServiceType
 * @subpackage Services
 */
class Navigate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NavigateAdministrativeUnitResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateAdministrativeUnitResults $parameters
     * @return \StructType\NavigateAdministrativeUnitResultsResponse|bool
     */
    public function NavigateAdministrativeUnitResults(\StructType\NavigateAdministrativeUnitResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateAdministrativeUnitResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * NavigateAdministrativeUnitMemberResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateAdministrativeUnitMemberResults $parameters
     * @return \StructType\NavigateAdministrativeUnitMemberResultsResponse|bool
     */
    public function NavigateAdministrativeUnitMemberResults(\StructType\NavigateAdministrativeUnitMemberResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateAdministrativeUnitMemberResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigatePartnerContracts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigatePartnerContracts $parameters
     * @return \StructType\NavigatePartnerContractsResponse|bool
     */
    public function NavigatePartnerContracts(\StructType\NavigatePartnerContracts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigatePartnerContracts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigateDirSyncProvisioningErrors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateDirSyncProvisioningErrors $parameters
     * @return \StructType\NavigateDirSyncProvisioningErrorsResponse|bool
     */
    public function NavigateDirSyncProvisioningErrors(\StructType\NavigateDirSyncProvisioningErrors $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateDirSyncProvisioningErrors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigateContactResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateContactResults $parameters
     * @return \StructType\NavigateContactResultsResponse|bool
     */
    public function NavigateContactResults(\StructType\NavigateContactResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateContactResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigateGroupResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateGroupResults $parameters
     * @return \StructType\NavigateGroupResultsResponse|bool
     */
    public function NavigateGroupResults(\StructType\NavigateGroupResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateGroupResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigateGroupMemberResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateGroupMemberResults $parameters
     * @return \StructType\NavigateGroupMemberResultsResponse|bool
     */
    public function NavigateGroupMemberResults(\StructType\NavigateGroupMemberResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateGroupMemberResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigateRoleMemberResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateRoleMemberResults $parameters
     * @return \StructType\NavigateRoleMemberResultsResponse|bool
     */
    public function NavigateRoleMemberResults(\StructType\NavigateRoleMemberResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateRoleMemberResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigateRoleScopedMemberResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateRoleScopedMemberResults $parameters
     * @return \StructType\NavigateRoleScopedMemberResultsResponse|bool
     */
    public function NavigateRoleScopedMemberResults(\StructType\NavigateRoleScopedMemberResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateRoleScopedMemberResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigateUserResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateUserResults $parameters
     * @return \StructType\NavigateUserResultsResponse|bool
     */
    public function NavigateUserResults(\StructType\NavigateUserResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateUserResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NavigateServicePrincipalResults
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NavigateServicePrincipalResults $parameters
     * @return \StructType\NavigateServicePrincipalResultsResponse|bool
     */
    public function NavigateServicePrincipalResults(\StructType\NavigateServicePrincipalResults $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NavigateServicePrincipalResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NavigateAdministrativeUnitMemberResultsResponse|\StructType\NavigateAdministrativeUnitResultsResponse|\StructType\NavigateContactResultsResponse|\StructType\NavigateDirSyncProvisioningErrorsResponse|\StructType\NavigateGroupMemberResultsResponse|\StructType\NavigateGroupResultsResponse|\StructType\NavigatePartnerContractsResponse|\StructType\NavigateRoleMemberResultsResponse|\StructType\NavigateRoleScopedMemberResultsResponse|\StructType\NavigateServicePrincipalResultsResponse|\StructType\NavigateUserResultsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
