<?php

namespace EnumType;

/**
 * This class stands for ValidationStatus EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidationStatus
 * @subpackage Enumerations
 */
class ValidationStatus
{
    /**
     * Constant for value 'NotAvailable'
     * @return string 'NotAvailable'
     */
    const VALUE_NOT_AVAILABLE = 'NotAvailable';
    /**
     * Constant for value 'Healthy'
     * @return string 'Healthy'
     */
    const VALUE_HEALTHY = 'Healthy';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_AVAILABLE
     * @uses self::VALUE_HEALTHY
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_AVAILABLE,
            self::VALUE_HEALTHY,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
