<?php

namespace EnumType;

/**
 * This class stands for StrongAuthenticationPhoneAppNotificationType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StrongAuthenticationPhoneAppNotificationType
 * @subpackage Enumerations
 */
class StrongAuthenticationPhoneAppNotificationType
{
    /**
     * Constant for value 'Unspecified'
     * @return string 'Unspecified'
     */
    const VALUE_UNSPECIFIED = 'Unspecified';
    /**
     * Constant for value 'Invalid'
     * @return string 'Invalid'
     */
    const VALUE_INVALID = 'Invalid';
    /**
     * Constant for value 'APNS'
     * @return string 'APNS'
     */
    const VALUE_APNS = 'APNS';
    /**
     * Constant for value 'C2DM'
     * @return string 'C2DM'
     */
    const VALUE_C_2_DM = 'C2DM';
    /**
     * Constant for value 'GCM'
     * @return string 'GCM'
     */
    const VALUE_GCM = 'GCM';
    /**
     * Constant for value 'MPNS'
     * @return string 'MPNS'
     */
    const VALUE_MPNS = 'MPNS';
    /**
     * Constant for value 'BPS'
     * @return string 'BPS'
     */
    const VALUE_BPS = 'BPS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNSPECIFIED
     * @uses self::VALUE_INVALID
     * @uses self::VALUE_APNS
     * @uses self::VALUE_C_2_DM
     * @uses self::VALUE_GCM
     * @uses self::VALUE_MPNS
     * @uses self::VALUE_BPS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNSPECIFIED,
            self::VALUE_INVALID,
            self::VALUE_APNS,
            self::VALUE_C_2_DM,
            self::VALUE_GCM,
            self::VALUE_MPNS,
            self::VALUE_BPS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
