<?php

namespace EnumType;

/**
 * This class stands for SkuTargetClass EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SkuTargetClass
 * @subpackage Enumerations
 */
class SkuTargetClass
{
    /**
     * Constant for value 'NotAvailable'
     * @return string 'NotAvailable'
     */
    const VALUE_NOT_AVAILABLE = 'NotAvailable';
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'Tenant'
     * @return string 'Tenant'
     */
    const VALUE_TENANT = 'Tenant';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_AVAILABLE
     * @uses self::VALUE_USER
     * @uses self::VALUE_TENANT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_AVAILABLE,
            self::VALUE_USER,
            self::VALUE_TENANT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
