<?php

namespace EnumType;

/**
 * This class stands for ServicePrincipalCredentialUsage EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServicePrincipalCredentialUsage
 * @subpackage Enumerations
 */
class ServicePrincipalCredentialUsage
{
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Sign'
     * @return string 'Sign'
     */
    const VALUE_SIGN = 'Sign';
    /**
     * Constant for value 'Verify'
     * @return string 'Verify'
     */
    const VALUE_VERIFY = 'Verify';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_SIGN
     * @uses self::VALUE_VERIFY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER,
            self::VALUE_SIGN,
            self::VALUE_VERIFY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
