<?php

namespace EnumType;

/**
 * This class stands for ProvisioningStatus EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProvisioningStatus
 * @subpackage Enumerations
 */
class ProvisioningStatus
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'PendingInput'
     * @return string 'PendingInput'
     */
    const VALUE_PENDING_INPUT = 'PendingInput';
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'PendingActivation'
     * @return string 'PendingActivation'
     */
    const VALUE_PENDING_ACTIVATION = 'PendingActivation';
    /**
     * Constant for value 'PendingProvisioning'
     * @return string 'PendingProvisioning'
     */
    const VALUE_PENDING_PROVISIONING = 'PendingProvisioning';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_PENDING_INPUT
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_PENDING_ACTIVATION
     * @uses self::VALUE_PENDING_PROVISIONING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SUCCESS,
            self::VALUE_ERROR,
            self::VALUE_PENDING_INPUT,
            self::VALUE_DISABLED,
            self::VALUE_PENDING_ACTIVATION,
            self::VALUE_PENDING_PROVISIONING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
