<?php

namespace EnumType;

/**
 * This class stands for O365UserReleaseTrack EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:O365UserReleaseTrack
 * @subpackage Enumerations
 */
class O365UserReleaseTrack
{
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'StagedRolloutOne'
     * @return string 'StagedRolloutOne'
     */
    const VALUE_STAGED_ROLLOUT_ONE = 'StagedRolloutOne';
    /**
     * Constant for value 'StagedRolloutTwo'
     * @return string 'StagedRolloutTwo'
     */
    const VALUE_STAGED_ROLLOUT_TWO = 'StagedRolloutTwo';
    /**
     * Constant for value 'Compass'
     * @return string 'Compass'
     */
    const VALUE_COMPASS = 'Compass';
    /**
     * Constant for value 'Dogfood'
     * @return string 'Dogfood'
     */
    const VALUE_DOGFOOD = 'Dogfood';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_STAGED_ROLLOUT_ONE
     * @uses self::VALUE_STAGED_ROLLOUT_TWO
     * @uses self::VALUE_COMPASS
     * @uses self::VALUE_DOGFOOD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER,
            self::VALUE_STAGED_ROLLOUT_ONE,
            self::VALUE_STAGED_ROLLOUT_TWO,
            self::VALUE_COMPASS,
            self::VALUE_DOGFOOD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
