<?php

namespace EnumType;

/**
 * This class stands for LicenseErrorType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LicenseErrorType
 * @subpackage Enumerations
 */
class LicenseErrorType
{
    /**
     * Constant for value 'MutuallyExclusiveViolation'
     * @return string 'MutuallyExclusiveViolation'
     */
    const VALUE_MUTUALLY_EXCLUSIVE_VIOLATION = 'MutuallyExclusiveViolation';
    /**
     * Constant for value 'DependencyViolation'
     * @return string 'DependencyViolation'
     */
    const VALUE_DEPENDENCY_VIOLATION = 'DependencyViolation';
    /**
     * Constant for value 'ProhibitedInUsageLocationViolation'
     * @return string 'ProhibitedInUsageLocationViolation'
     */
    const VALUE_PROHIBITED_IN_USAGE_LOCATION_VIOLATION = 'ProhibitedInUsageLocationViolation';
    /**
     * Constant for value 'RestrictedInUsageLocationViolation'
     * @return string 'RestrictedInUsageLocationViolation'
     */
    const VALUE_RESTRICTED_IN_USAGE_LOCATION_VIOLATION = 'RestrictedInUsageLocationViolation';
    /**
     * Constant for value 'OnPremiseMailboxViolation'
     * @return string 'OnPremiseMailboxViolation'
     */
    const VALUE_ON_PREMISE_MAILBOX_VIOLATION = 'OnPremiseMailboxViolation';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MUTUALLY_EXCLUSIVE_VIOLATION
     * @uses self::VALUE_DEPENDENCY_VIOLATION
     * @uses self::VALUE_PROHIBITED_IN_USAGE_LOCATION_VIOLATION
     * @uses self::VALUE_RESTRICTED_IN_USAGE_LOCATION_VIOLATION
     * @uses self::VALUE_ON_PREMISE_MAILBOX_VIOLATION
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MUTUALLY_EXCLUSIVE_VIOLATION,
            self::VALUE_DEPENDENCY_VIOLATION,
            self::VALUE_PROHIBITED_IN_USAGE_LOCATION_VIOLATION,
            self::VALUE_RESTRICTED_IN_USAGE_LOCATION_VIOLATION,
            self::VALUE_ON_PREMISE_MAILBOX_VIOLATION,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
