<?php

namespace EnumType;

/**
 * This class stands for GroupType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupType
 * @subpackage Enumerations
 */
class GroupType
{
    /**
     * Constant for value 'DistributionList'
     * @return string 'DistributionList'
     */
    const VALUE_DISTRIBUTION_LIST = 'DistributionList';
    /**
     * Constant for value 'Security'
     * @return string 'Security'
     */
    const VALUE_SECURITY = 'Security';
    /**
     * Constant for value 'MailEnabledSecurity'
     * @return string 'MailEnabledSecurity'
     */
    const VALUE_MAIL_ENABLED_SECURITY = 'MailEnabledSecurity';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISTRIBUTION_LIST
     * @uses self::VALUE_SECURITY
     * @uses self::VALUE_MAIL_ENABLED_SECURITY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISTRIBUTION_LIST,
            self::VALUE_SECURITY,
            self::VALUE_MAIL_ENABLED_SECURITY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
