<?php

namespace EnumType;

/**
 * This class stands for DomainVerificationMode EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainVerificationMode
 * @subpackage Enumerations
 */
class DomainVerificationMode
{
    /**
     * Constant for value 'DnsTxtRecord'
     * @return string 'DnsTxtRecord'
     */
    const VALUE_DNS_TXT_RECORD = 'DnsTxtRecord';
    /**
     * Constant for value 'DnsMXRecord'
     * @return string 'DnsMXRecord'
     */
    const VALUE_DNS_MXRECORD = 'DnsMXRecord';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DNS_TXT_RECORD
     * @uses self::VALUE_DNS_MXRECORD
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DNS_TXT_RECORD,
            self::VALUE_DNS_MXRECORD,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
