<?php

namespace EnumType;

/**
 * This class stands for DirSyncStatus EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DirSyncStatus
 * @subpackage Enumerations
 */
class DirSyncStatus
{
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'Enabled'
     * @return string 'Enabled'
     */
    const VALUE_ENABLED = 'Enabled';
    /**
     * Constant for value 'PendingEnabled'
     * @return string 'PendingEnabled'
     */
    const VALUE_PENDING_ENABLED = 'PendingEnabled';
    /**
     * Constant for value 'PendingDisabled'
     * @return string 'PendingDisabled'
     */
    const VALUE_PENDING_DISABLED = 'PendingDisabled';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_ENABLED
     * @uses self::VALUE_PENDING_ENABLED
     * @uses self::VALUE_PENDING_DISABLED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLED,
            self::VALUE_ENABLED,
            self::VALUE_PENDING_ENABLED,
            self::VALUE_PENDING_DISABLED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
