<?php

namespace EnumType;

/**
 * This class stands for DirSyncDeletionPreventionType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DirSyncDeletionPreventionType
 * @subpackage Enumerations
 */
class DirSyncDeletionPreventionType
{
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'EnabledForCount'
     * @return string 'EnabledForCount'
     */
    const VALUE_ENABLED_FOR_COUNT = 'EnabledForCount';
    /**
     * Constant for value 'EnabledForPercentage'
     * @return string 'EnabledForPercentage'
     */
    const VALUE_ENABLED_FOR_PERCENTAGE = 'EnabledForPercentage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_ENABLED_FOR_COUNT
     * @uses self::VALUE_ENABLED_FOR_PERCENTAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLED,
            self::VALUE_ENABLED_FOR_COUNT,
            self::VALUE_ENABLED_FOR_PERCENTAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
