<?php

namespace EnumType;

/**
 * This class stands for AuthorizedService EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthorizedService
 * @subpackage Enumerations
 */
class AuthorizedService
{
    /**
     * Constant for value 'Blackberry'
     * @return string 'Blackberry'
     */
    const VALUE_BLACKBERRY = 'Blackberry';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BLACKBERRY
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BLACKBERRY,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
