<?php

namespace EnumType;

/**
 * This class stands for AuthenticationProtocol EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AuthenticationProtocol
 * @subpackage Enumerations
 */
class AuthenticationProtocol
{
    /**
     * Constant for value 'WsFed'
     * @return string 'WsFed'
     */
    const VALUE_WS_FED = 'WsFed';
    /**
     * Constant for value 'Samlp'
     * @return string 'Samlp'
     */
    const VALUE_SAMLP = 'Samlp';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WS_FED
     * @uses self::VALUE_SAMLP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WS_FED,
            self::VALUE_SAMLP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
