<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ArrayOfstring' => '\\ArrayType\\ArrayOfstring',
            'ArrayOfguid' => '\\ArrayType\\ArrayOfguid',
            'ArrayOfKeyValueOfstringstring' => '\\ArrayType\\ArrayOfKeyValueOfstringstring',
            'KeyValueOfstringstring' => '\\StructType\\KeyValueOfstringstring',
            'ArrayOfXElement' => '\\ArrayType\\ArrayOfXElement',
            'XElement' => '\\StructType\\XElement',
            'PartnerInformation' => '\\StructType\\PartnerInformation',
            'ArrayOfPartnerContract' => '\\ArrayType\\ArrayOfPartnerContract',
            'PartnerContract' => '\\StructType\\PartnerContract',
            'ArrayOfPartnerRoleMapEntry' => '\\ArrayType\\ArrayOfPartnerRoleMapEntry',
            'PartnerRoleMapEntry' => '\\StructType\\PartnerRoleMapEntry',
            'AdministrativeUnit' => '\\StructType\\AdministrativeUnit',
            'AdministrativeUnitSearchDefinition' => '\\StructType\\AdministrativeUnitSearchDefinition',
            'SearchDefinition' => '\\StructType\\SearchDefinition',
            'ListAdministrativeUnitResults' => '\\StructType\\ListAdministrativeUnitResults',
            'ListResults' => '\\StructType\\ListResults',
            'ArrayOfAdministrativeUnit' => '\\ArrayType\\ArrayOfAdministrativeUnit',
            'ArrayOfAdministrativeUnitMember' => '\\ArrayType\\ArrayOfAdministrativeUnitMember',
            'AdministrativeUnitMember' => '\\StructType\\AdministrativeUnitMember',
            'AdministrativeUnitMemberSearchDefinition' => '\\StructType\\AdministrativeUnitMemberSearchDefinition',
            'ListAdministrativeUnitMemberResults' => '\\StructType\\ListAdministrativeUnitMemberResults',
            'CompanyInformation' => '\\StructType\\CompanyInformation',
            'PortalSettings' => '\\StructType\\PortalSettings',
            'ArrayOfAuthorizedService' => '\\ArrayType\\ArrayOfAuthorizedService',
            'ArrayOfServiceInformation' => '\\ArrayType\\ArrayOfServiceInformation',
            'ServiceInformation' => '\\StructType\\ServiceInformation',
            'ArrayOfServiceInstanceInformation' => '\\ArrayType\\ArrayOfServiceInstanceInformation',
            'ServiceInstanceInformation' => '\\StructType\\ServiceInstanceInformation',
            'GeographicLocation' => '\\StructType\\GeographicLocation',
            'ArrayOfServiceEndpoint' => '\\ArrayType\\ArrayOfServiceEndpoint',
            'ServiceEndpoint' => '\\StructType\\ServiceEndpoint',
            'Subscription' => '\\StructType\\Subscription',
            'ArrayOfServiceStatus' => '\\ArrayType\\ArrayOfServiceStatus',
            'ServiceStatus' => '\\StructType\\ServiceStatus',
            'ServicePlan' => '\\StructType\\ServicePlan',
            'ArrayOfSubscription' => '\\ArrayType\\ArrayOfSubscription',
            'ArrayOfAccountSkuDetails' => '\\ArrayType\\ArrayOfAccountSkuDetails',
            'AccountSkuDetails' => '\\StructType\\AccountSkuDetails',
            'AccidentalDeletionInformation' => '\\StructType\\AccidentalDeletionInformation',
            'ArrayOfDirSyncFeatureDetails' => '\\ArrayType\\ArrayOfDirSyncFeatureDetails',
            'DirSyncFeatureDetails' => '\\StructType\\DirSyncFeatureDetails',
            'CompanySettings' => '\\StructType\\CompanySettings',
            'PartnerContractSearchDefinition' => '\\StructType\\PartnerContractSearchDefinition',
            'ListPartnerContractResults' => '\\StructType\\ListPartnerContractResults',
            'PasswordPolicy' => '\\StructType\\PasswordPolicy',
            'DirSyncProvisioningErrorSearchDefinition' => '\\StructType\\DirSyncProvisioningErrorSearchDefinition',
            'ListObjectsWithDirSyncErrorResults' => '\\StructType\\ListObjectsWithDirSyncErrorResults',
            'ArrayOfObjectWithDirSyncErrors' => '\\ArrayType\\ArrayOfObjectWithDirSyncErrors',
            'ObjectWithDirSyncErrors' => '\\StructType\\ObjectWithDirSyncErrors',
            'ArrayOfDirSyncProvisioningError' => '\\ArrayType\\ArrayOfDirSyncProvisioningError',
            'DirSyncProvisioningError' => '\\StructType\\DirSyncProvisioningError',
            'ArrayOfAllowedDataLocation' => '\\ArrayType\\ArrayOfAllowedDataLocation',
            'AllowedDataLocation' => '\\StructType\\AllowedDataLocation',
            'Contact' => '\\StructType\\Contact',
            'ArrayOfValidationError' => '\\ArrayType\\ArrayOfValidationError',
            'ValidationError' => '\\StructType\\ValidationError',
            'ErrorDetail' => '\\StructType\\ErrorDetail',
            'ContactSearchDefinition' => '\\StructType\\ContactSearchDefinition',
            'ListContactResults' => '\\StructType\\ListContactResults',
            'ArrayOfContact' => '\\ArrayType\\ArrayOfContact',
            'Domain' => '\\StructType\\Domain',
            'DomainFederationSettings' => '\\StructType\\DomainFederationSettings',
            'SigningCertificateUpdateStatus' => '\\StructType\\SigningCertificateUpdateStatus',
            'DomainVerificationResult' => '\\StructType\\DomainVerificationResult',
            'EmailVerifiedDomainInformation' => '\\StructType\\EmailVerifiedDomainInformation',
            'EmailVerifiedDomainVerificationResult' => '\\StructType\\EmailVerifiedDomainVerificationResult',
            'DomainSearchFilter' => '\\StructType\\DomainSearchFilter',
            'ArrayOfDomain' => '\\ArrayType\\ArrayOfDomain',
            'DomainDnsRecord' => '\\StructType\\DomainDnsRecord',
            'DomainDnsCnameRecord' => '\\StructType\\DomainDnsCnameRecord',
            'DomainDnsMXRecord' => '\\StructType\\DomainDnsMXRecord',
            'DomainDnsTxtRecord' => '\\StructType\\DomainDnsTxtRecord',
            'DomainDnsSrvRecord' => '\\StructType\\DomainDnsSrvRecord',
            'DomainDnsNullRecord' => '\\StructType\\DomainDnsNullRecord',
            'Group' => '\\StructType\\Group',
            'ArrayOfAssignedLicense' => '\\ArrayType\\ArrayOfAssignedLicense',
            'AssignedLicense' => '\\StructType\\AssignedLicense',
            'AccountSkuIdentifier' => '\\StructType\\AccountSkuIdentifier',
            'GroupLicenseProcessingDetail' => '\\StructType\\GroupLicenseProcessingDetail',
            'ArrayOfAccountSkuIdentifier' => '\\ArrayType\\ArrayOfAccountSkuIdentifier',
            'GroupSearchDefinition' => '\\StructType\\GroupSearchDefinition',
            'ListGroupResults' => '\\StructType\\ListGroupResults',
            'ArrayOfGroup' => '\\ArrayType\\ArrayOfGroup',
            'ArrayOfGroupMember' => '\\ArrayType\\ArrayOfGroupMember',
            'GroupMember' => '\\StructType\\GroupMember',
            'GroupMemberSearchDefinition' => '\\StructType\\GroupMemberSearchDefinition',
            'ListGroupMemberResults' => '\\StructType\\ListGroupMemberResults',
            'Role' => '\\StructType\\Role',
            'ArrayOfRole' => '\\ArrayType\\ArrayOfRole',
            'ArrayOfRoleMember' => '\\ArrayType\\ArrayOfRoleMember',
            'RoleMember' => '\\StructType\\RoleMember',
            'ArrayOfStrongAuthenticationRequirement' => '\\ArrayType\\ArrayOfStrongAuthenticationRequirement',
            'StrongAuthenticationRequirement' => '\\StructType\\StrongAuthenticationRequirement',
            'RoleMemberSearchDefinition' => '\\StructType\\RoleMemberSearchDefinition',
            'ListRoleMemberResults' => '\\StructType\\ListRoleMemberResults',
            'ArrayOfRoleScopedMember' => '\\ArrayType\\ArrayOfRoleScopedMember',
            'RoleScopedMember' => '\\StructType\\RoleScopedMember',
            'RoleScopedMemberSearchDefinition' => '\\StructType\\RoleScopedMemberSearchDefinition',
            'ListRoleScopedMemberResults' => '\\StructType\\ListRoleScopedMemberResults',
            'ArrayOfLicenseOption' => '\\ArrayType\\ArrayOfLicenseOption',
            'LicenseOption' => '\\StructType\\LicenseOption',
            'User' => '\\StructType\\User',
            'ArrayOfAlternativeSecurityId' => '\\ArrayType\\ArrayOfAlternativeSecurityId',
            'AlternativeSecurityId' => '\\StructType\\AlternativeSecurityId',
            'ArrayOfIndirectLicenseError' => '\\ArrayType\\ArrayOfIndirectLicenseError',
            'IndirectLicenseError' => '\\StructType\\IndirectLicenseError',
            'ArrayOfLicenseAssignmentDetail' => '\\ArrayType\\ArrayOfLicenseAssignmentDetail',
            'LicenseAssignmentDetail' => '\\StructType\\LicenseAssignmentDetail',
            'ArrayOfLicenseAssignment' => '\\ArrayType\\ArrayOfLicenseAssignment',
            'LicenseAssignment' => '\\StructType\\LicenseAssignment',
            'ArrayOfUserLicense' => '\\ArrayType\\ArrayOfUserLicense',
            'UserLicense' => '\\StructType\\UserLicense',
            'ArrayOfStrongAuthenticationMethod' => '\\ArrayType\\ArrayOfStrongAuthenticationMethod',
            'StrongAuthenticationMethod' => '\\StructType\\StrongAuthenticationMethod',
            'ArrayOfStrongAuthenticationPhoneAppDetail' => '\\ArrayType\\ArrayOfStrongAuthenticationPhoneAppDetail',
            'StrongAuthenticationPhoneAppDetail' => '\\StructType\\StrongAuthenticationPhoneAppDetail',
            'StrongAuthenticationUserDetails' => '\\StructType\\StrongAuthenticationUserDetails',
            'UserExtended' => '\\StructType\\UserExtended',
            'ArrayOfLicenseErrorDetail' => '\\ArrayType\\ArrayOfLicenseErrorDetail',
            'LicenseErrorDetail' => '\\StructType\\LicenseErrorDetail',
            'UserSearchDefinition' => '\\StructType\\UserSearchDefinition',
            'IndirectLicenseFilter' => '\\StructType\\IndirectLicenseFilter',
            'ListUserResults' => '\\StructType\\ListUserResults',
            'ArrayOfUser' => '\\ArrayType\\ArrayOfUser',
            'UserSearchByStrongAuthenticationDefinition' => '\\StructType\\UserSearchByStrongAuthenticationDefinition',
            'ArrayOfRestoreUserError' => '\\ArrayType\\ArrayOfRestoreUserError',
            'RestoreUserError' => '\\StructType\\RestoreUserError',
            'ArrayOfRedirectUri' => '\\ArrayType\\ArrayOfRedirectUri',
            'RedirectUri' => '\\StructType\\RedirectUri',
            'ArrayOfServicePrincipalCredential' => '\\ArrayType\\ArrayOfServicePrincipalCredential',
            'ServicePrincipalCredential' => '\\StructType\\ServicePrincipalCredential',
            'ServicePrincipalExtended' => '\\StructType\\ServicePrincipalExtended',
            'ServicePrincipal' => '\\StructType\\ServicePrincipal',
            'ServicePrincipalSearchDefinition' => '\\StructType\\ServicePrincipalSearchDefinition',
            'ListServicePrincipalResults' => '\\StructType\\ListServicePrincipalResults',
            'ArrayOfServicePrincipal' => '\\ArrayType\\ArrayOfServicePrincipal',
            'Request' => '\\StructType\\Request',
            'GetHeaderInfoResponse' => '\\StructType\\GetHeaderInfoResponse',
            'Response' => '\\StructType\\Response',
            'ClientVersionHeader' => '\\StructType\\ClientVersionHeader',
            'Context' => '\\StructType\\Context',
            'ContractVersionHeader' => '\\StructType\\ContractVersionHeader',
            'UserIdentityHeader' => '\\StructType\\UserIdentityHeader',
            'TrackingHeader' => '\\StructType\\TrackingHeader',
            'MsolConnectResponse' => '\\StructType\\MsolConnectResponse',
            'UserAccountDisabledException' => '\\StructType\\UserAccountDisabledException',
            'MsolAdministrationException' => '\\StructType\\MsolAdministrationException',
            'LiveTokenExpiredException' => '\\StructType\\LiveTokenExpiredException',
            'ServiceUnavailableException' => '\\StructType\\ServiceUnavailableException',
            'InternalServiceException' => '\\StructType\\InternalServiceException',
            'InvalidParameterException' => '\\StructType\\InvalidParameterException',
            'InvalidContextException' => '\\StructType\\InvalidContextException',
            'ObjectNotFoundException' => '\\StructType\\ObjectNotFoundException',
            'DataOperationException' => '\\StructType\\DataOperationException',
            'AccessDeniedException' => '\\StructType\\AccessDeniedException',
            'CompanyNotFoundException' => '\\StructType\\CompanyNotFoundException',
            'UserNotFoundException' => '\\StructType\\UserNotFoundException',
            'DirectoryInternalServiceException' => '\\StructType\\DirectoryInternalServiceException',
            'InvalidHeaderException' => '\\StructType\\InvalidHeaderException',
            'ThrottlingException' => '\\StructType\\ThrottlingException',
            'ClientVersionException' => '\\StructType\\ClientVersionException',
            'BindingRedirectionException' => '\\StructType\\BindingRedirectionException',
            'GetPartnerInformationResponse' => '\\StructType\\GetPartnerInformationResponse',
            'AddAdministrativeUnitRequest' => '\\StructType\\AddAdministrativeUnitRequest',
            'AddAdministrativeUnitResponse' => '\\StructType\\AddAdministrativeUnitResponse',
            'PropertyNotSettableException' => '\\StructType\\PropertyNotSettableException',
            'PropertyValidationException' => '\\StructType\\PropertyValidationException',
            'UniquenessValidationException' => '\\StructType\\UniquenessValidationException',
            'StringLengthValidationException' => '\\StructType\\StringLengthValidationException',
            'StringSyntaxValidationException' => '\\StructType\\StringSyntaxValidationException',
            'RequiredPropertyNotSetException' => '\\StructType\\RequiredPropertyNotSetException',
            'QuotaExceededException' => '\\StructType\\QuotaExceededException',
            'TransientServiceErrorException' => '\\StructType\\TransientServiceErrorException',
            'GetAdministrativeUnitRequest' => '\\StructType\\GetAdministrativeUnitRequest',
            'GetAdministrativeUnitResponse' => '\\StructType\\GetAdministrativeUnitResponse',
            'AdministrativeUnitNotFoundException' => '\\StructType\\AdministrativeUnitNotFoundException',
            'SetAdministrativeUnitRequest' => '\\StructType\\SetAdministrativeUnitRequest',
            'RemoveAdministrativeUnitRequest' => '\\StructType\\RemoveAdministrativeUnitRequest',
            'ListAdministrativeUnitsRequest' => '\\StructType\\ListAdministrativeUnitsRequest',
            'ListAdministrativeUnitsResponse' => '\\StructType\\ListAdministrativeUnitsResponse',
            'TooManySearchResultsException' => '\\StructType\\TooManySearchResultsException',
            'ItemCountValidationException' => '\\StructType\\ItemCountValidationException',
            'NavigateAdministrativeUnitResultsRequest' => '\\StructType\\NavigateAdministrativeUnitResultsRequest',
            'NavigateAdministrativeUnitResultsResponse' => '\\StructType\\NavigateAdministrativeUnitResultsResponse',
            'PageNotAvailableException' => '\\StructType\\PageNotAvailableException',
            'InvalidListContextException' => '\\StructType\\InvalidListContextException',
            'AddAdministrativeUnitMembersRequest' => '\\StructType\\AddAdministrativeUnitMembersRequest',
            'AdministrativeUnitMemberNotFoundException' => '\\StructType\\AdministrativeUnitMemberNotFoundException',
            'MemberAlreadyExistsException' => '\\StructType\\MemberAlreadyExistsException',
            'ObjectAlreadyExistsException' => '\\StructType\\ObjectAlreadyExistsException',
            'AdministrativeUnitMemberNotAllowedException' => '\\StructType\\AdministrativeUnitMemberNotAllowedException',
            'RemoveAdministrativeUnitMembersRequest' => '\\StructType\\RemoveAdministrativeUnitMembersRequest',
            'ListAdministrativeUnitMembersRequest' => '\\StructType\\ListAdministrativeUnitMembersRequest',
            'ListAdministrativeUnitMembersResponse' => '\\StructType\\ListAdministrativeUnitMembersResponse',
            'NavigateAdministrativeUnitMemberResultsRequest' => '\\StructType\\NavigateAdministrativeUnitMemberResultsRequest',
            'NavigateAdministrativeUnitMemberResultsResponse' => '\\StructType\\NavigateAdministrativeUnitMemberResultsResponse',
            'GetCompanyInformationResponse' => '\\StructType\\GetCompanyInformationResponse',
            'GetSubscriptionRequest' => '\\StructType\\GetSubscriptionRequest',
            'GetSubscriptionResponse' => '\\StructType\\GetSubscriptionResponse',
            'SubscriptionNotFoundException' => '\\StructType\\SubscriptionNotFoundException',
            'ListSubscriptionsResponse' => '\\StructType\\ListSubscriptionsResponse',
            'ListAccountSkusRequest' => '\\StructType\\ListAccountSkusRequest',
            'ListAccountSkusResponse' => '\\StructType\\ListAccountSkusResponse',
            'SetPartnerInformationRequest' => '\\StructType\\SetPartnerInformationRequest',
            'SetCompanyContactInformationRequest' => '\\StructType\\SetCompanyContactInformationRequest',
            'SetCompanySecurityComplianceContactInformationRequest' => '\\StructType\\SetCompanySecurityComplianceContactInformationRequest',
            'SetCompanyDirSyncEnabledRequest' => '\\StructType\\SetCompanyDirSyncEnabledRequest',
            'DirSyncStatusChangeNotAllowedException' => '\\StructType\\DirSyncStatusChangeNotAllowedException',
            'SetAccidentalDeletionThresholdRequest' => '\\StructType\\SetAccidentalDeletionThresholdRequest',
            'DeletionPreventionConfigurationException' => '\\StructType\\DeletionPreventionConfigurationException',
            'GetAccidentalDeletionInformationResponse' => '\\StructType\\GetAccidentalDeletionInformationResponse',
            'SetCompanyDirSyncFeatureRequest' => '\\StructType\\SetCompanyDirSyncFeatureRequest',
            'DirSyncFeatureUpdateNotAllowedException' => '\\StructType\\DirSyncFeatureUpdateNotAllowedException',
            'GetCompanyDirSyncFeaturesRequest' => '\\StructType\\GetCompanyDirSyncFeaturesRequest',
            'GetCompanyDirSyncFeaturesResponse' => '\\StructType\\GetCompanyDirSyncFeaturesResponse',
            'DirSyncFeatureReadNotAllowedException' => '\\StructType\\DirSyncFeatureReadNotAllowedException',
            'SetCompanyPasswordSyncEnabledRequest' => '\\StructType\\SetCompanyPasswordSyncEnabledRequest',
            'PasswordSyncStatusChangeNotAllowedException' => '\\StructType\\PasswordSyncStatusChangeNotAllowedException',
            'SetCompanySettingsRequest' => '\\StructType\\SetCompanySettingsRequest',
            'ListPartnerContractsRequest' => '\\StructType\\ListPartnerContractsRequest',
            'ListPartnerContractsResponse' => '\\StructType\\ListPartnerContractsResponse',
            'TenantNotPartnerTypeException' => '\\StructType\\TenantNotPartnerTypeException',
            'ContractNotFoundException' => '\\StructType\\ContractNotFoundException',
            'DomainNotFoundException' => '\\StructType\\DomainNotFoundException',
            'NavigatePartnerContractsRequest' => '\\StructType\\NavigatePartnerContractsRequest',
            'NavigatePartnerContractsResponse' => '\\StructType\\NavigatePartnerContractsResponse',
            'GetPasswordPolicyRequest' => '\\StructType\\GetPasswordPolicyRequest',
            'GetPasswordPolicyResponse' => '\\StructType\\GetPasswordPolicyResponse',
            'DomainNotRootException' => '\\StructType\\DomainNotRootException',
            'DomainDataOperationException' => '\\StructType\\DomainDataOperationException',
            'DomainOperationNotAllowedException' => '\\StructType\\DomainOperationNotAllowedException',
            'SetPasswordPolicyRequest' => '\\StructType\\SetPasswordPolicyRequest',
            'ListDirSyncProvisioningErrorsRequest' => '\\StructType\\ListDirSyncProvisioningErrorsRequest',
            'ListDirSyncProvisioningErrorsResponse' => '\\StructType\\ListDirSyncProvisioningErrorsResponse',
            'NavigateDirSyncProvisioningErrorsRequest' => '\\StructType\\NavigateDirSyncProvisioningErrorsRequest',
            'NavigateDirSyncProvisioningErrorsResponse' => '\\StructType\\NavigateDirSyncProvisioningErrorsResponse',
            'HasObjectsWithDirSyncProvisioningErrorsResponse' => '\\StructType\\HasObjectsWithDirSyncProvisioningErrorsResponse',
            'HasObjectsWithDirSyncProvisioningErrors2Request' => '\\StructType\\HasObjectsWithDirSyncProvisioningErrors2Request',
            'HasObjectsWithDirSyncProvisioningErrors2Response' => '\\StructType\\HasObjectsWithDirSyncProvisioningErrors2Response',
            'UpdateDirSyncProvisioningErrorRequest' => '\\StructType\\UpdateDirSyncProvisioningErrorRequest',
            'SetCompanyMultiNationalEnabledRequest' => '\\StructType\\SetCompanyMultiNationalEnabledRequest',
            'OperationNotAllowedException' => '\\StructType\\OperationNotAllowedException',
            'SetCompanyAllowedDataLocationRequest' => '\\StructType\\SetCompanyAllowedDataLocationRequest',
            'GetCompanyAllowedDataLocationResponse' => '\\StructType\\GetCompanyAllowedDataLocationResponse',
            'RemoveContactRequest' => '\\StructType\\RemoveContactRequest',
            'ContactNotFoundException' => '\\StructType\\ContactNotFoundException',
            'GetContactRequest' => '\\StructType\\GetContactRequest',
            'GetContactResponse' => '\\StructType\\GetContactResponse',
            'ListContactsRequest' => '\\StructType\\ListContactsRequest',
            'ListContactsResponse' => '\\StructType\\ListContactsResponse',
            'NavigateContactResultsRequest' => '\\StructType\\NavigateContactResultsRequest',
            'NavigateContactResultsResponse' => '\\StructType\\NavigateContactResultsResponse',
            'RetryContactProvisioningRequest' => '\\StructType\\RetryContactProvisioningRequest',
            'AddDomainRequest' => '\\StructType\\AddDomainRequest',
            'AddDomainResponse' => '\\StructType\\AddDomainResponse',
            'DomainTakeoverFederatedSubDomainNotSupportedException' => '\\StructType\\DomainTakeoverFederatedSubDomainNotSupportedException',
            'DomainNameForbiddenWordException' => '\\StructType\\DomainNameForbiddenWordException',
            'DomainAlreadyExistsException' => '\\StructType\\DomainAlreadyExistsException',
            'TooManyUnverifiedDomainException' => '\\StructType\\TooManyUnverifiedDomainException',
            'TooManyVerifiedDomainException' => '\\StructType\\TooManyVerifiedDomainException',
            'DomainUnexpectedAuthenticationException' => '\\StructType\\DomainUnexpectedAuthenticationException',
            'DomainCapabilitySetException' => '\\StructType\\DomainCapabilitySetException',
            'DomainLiveNamespaceExistsException' => '\\StructType\\DomainLiveNamespaceExistsException',
            'DomainAlreadyExistsInOldSystemException' => '\\StructType\\DomainAlreadyExistsInOldSystemException',
            'IdentityInternalServiceException' => '\\StructType\\IdentityInternalServiceException',
            'DomainTakeoverFederatedRootDomainNotSupportedException' => '\\StructType\\DomainTakeoverFederatedRootDomainNotSupportedException',
            'NonWhitelistedServicePlanException' => '\\StructType\\NonWhitelistedServicePlanException',
            'VerifyDomainRequest' => '\\StructType\\VerifyDomainRequest',
            'DomainVerificationMissingCnameException' => '\\StructType\\DomainVerificationMissingCnameException',
            'IdentityTransientErrorException' => '\\StructType\\IdentityTransientErrorException',
            'DomainPendingDeletionException' => '\\StructType\\DomainPendingDeletionException',
            'DomainVerificationWrongCnameTargetException' => '\\StructType\\DomainVerificationWrongCnameTargetException',
            'DomainVerificationMissingDnsRecordException' => '\\StructType\\DomainVerificationMissingDnsRecordException',
            'DomainLiveNamespaceUnmanagedException' => '\\StructType\\DomainLiveNamespaceUnmanagedException',
            'DomainNameConflictException' => '\\StructType\\DomainNameConflictException',
            'DomainLiveNamespaceUriConflictException' => '\\StructType\\DomainLiveNamespaceUriConflictException',
            'DomainLiveNamespaceAuthenticationException' => '\\StructType\\DomainLiveNamespaceAuthenticationException',
            'VerifyDomain2Request' => '\\StructType\\VerifyDomain2Request',
            'VerifyDomain2Response' => '\\StructType\\VerifyDomain2Response',
            'DomainTakeoverNotScheduledException' => '\\StructType\\DomainTakeoverNotScheduledException',
            'VerifyEmailVerifiedDomainRequest' => '\\StructType\\VerifyEmailVerifiedDomainRequest',
            'VerifyEmailVerifiedDomainResponse' => '\\StructType\\VerifyEmailVerifiedDomainResponse',
            'DomainNotEmailVerifiedException' => '\\StructType\\DomainNotEmailVerifiedException',
            'RemoveDomainRequest' => '\\StructType\\RemoveDomainRequest',
            'DomainUsedInApplicationException' => '\\StructType\\DomainUsedInApplicationException',
            'DefaultDomainDeletionException' => '\\StructType\\DefaultDomainDeletionException',
            'InitialDomainDeletionException' => '\\StructType\\InitialDomainDeletionException',
            'DomainHasChildDomainException' => '\\StructType\\DomainHasChildDomainException',
            'DomainNotEmptyException' => '\\StructType\\DomainNotEmptyException',
            'DomainCapabilityUnsetException' => '\\StructType\\DomainCapabilityUnsetException',
            'SetDomainRequest' => '\\StructType\\SetDomainRequest',
            'InitialDomainUpdateException' => '\\StructType\\InitialDomainUpdateException',
            'SetUnverifiedDomainAsDefaultException' => '\\StructType\\SetUnverifiedDomainAsDefaultException',
            'DefaultDomainUnsetException' => '\\StructType\\DefaultDomainUnsetException',
            'DefaultDomainInvalidAuthenticationException' => '\\StructType\\DefaultDomainInvalidAuthenticationException',
            'DomainOverlappingOperationException' => '\\StructType\\DomainOverlappingOperationException',
            'DomainCapabilityUnavailableException' => '\\StructType\\DomainCapabilityUnavailableException',
            'SetDomainAuthenticationRequest' => '\\StructType\\SetDomainAuthenticationRequest',
            'GetDomainFederationSettingsRequest' => '\\StructType\\GetDomainFederationSettingsRequest',
            'GetDomainFederationSettingsResponse' => '\\StructType\\GetDomainFederationSettingsResponse',
            'SetDomainFederationSettingsRequest' => '\\StructType\\SetDomainFederationSettingsRequest',
            'GetDomainRequest' => '\\StructType\\GetDomainRequest',
            'GetDomainResponse' => '\\StructType\\GetDomainResponse',
            'ListDomainsRequest' => '\\StructType\\ListDomainsRequest',
            'ListDomainsResponse' => '\\StructType\\ListDomainsResponse',
            'GetDomainVerificationDnsRequest' => '\\StructType\\GetDomainVerificationDnsRequest',
            'GetDomainVerificationDnsResponse' => '\\StructType\\GetDomainVerificationDnsResponse',
            'AddGroupRequest' => '\\StructType\\AddGroupRequest',
            'AddGroupResponse' => '\\StructType\\AddGroupResponse',
            'GroupAlreadyExistsException' => '\\StructType\\GroupAlreadyExistsException',
            'MailEnabledGroupsNotSupportedException' => '\\StructType\\MailEnabledGroupsNotSupportedException',
            'AddWellKnownGroupRequest' => '\\StructType\\AddWellKnownGroupRequest',
            'AddWellKnownGroupResponse' => '\\StructType\\AddWellKnownGroupResponse',
            'RemoveGroupRequest' => '\\StructType\\RemoveGroupRequest',
            'GroupDeletionNotAllowedException' => '\\StructType\\GroupDeletionNotAllowedException',
            'GroupNotFoundException' => '\\StructType\\GroupNotFoundException',
            'SetGroupRequest' => '\\StructType\\SetGroupRequest',
            'GroupUpdateNotAllowedException' => '\\StructType\\GroupUpdateNotAllowedException',
            'GetGroupRequest' => '\\StructType\\GetGroupRequest',
            'GetGroupResponse' => '\\StructType\\GetGroupResponse',
            'ListGroupsRequest' => '\\StructType\\ListGroupsRequest',
            'ListGroupsResponse' => '\\StructType\\ListGroupsResponse',
            'NavigateGroupResultsRequest' => '\\StructType\\NavigateGroupResultsRequest',
            'NavigateGroupResultsResponse' => '\\StructType\\NavigateGroupResultsResponse',
            'AddGroupMembersRequest' => '\\StructType\\AddGroupMembersRequest',
            'GroupMemberNotFoundException' => '\\StructType\\GroupMemberNotFoundException',
            'DynamicGroupsNotSupportedException' => '\\StructType\\DynamicGroupsNotSupportedException',
            'RemoveGroupMembersRequest' => '\\StructType\\RemoveGroupMembersRequest',
            'ListGroupMembersRequest' => '\\StructType\\ListGroupMembersRequest',
            'ListGroupMembersResponse' => '\\StructType\\ListGroupMembersResponse',
            'NavigateGroupMemberResultsRequest' => '\\StructType\\NavigateGroupMemberResultsRequest',
            'NavigateGroupMemberResultsResponse' => '\\StructType\\NavigateGroupMemberResultsResponse',
            'RetryGroupProvisioningRequest' => '\\StructType\\RetryGroupProvisioningRequest',
            'GetRoleRequest' => '\\StructType\\GetRoleRequest',
            'GetRoleResponse' => '\\StructType\\GetRoleResponse',
            'RoleNotFoundException' => '\\StructType\\RoleNotFoundException',
            'GetRoleByNameRequest' => '\\StructType\\GetRoleByNameRequest',
            'GetRoleByNameResponse' => '\\StructType\\GetRoleByNameResponse',
            'ListRolesResponse' => '\\StructType\\ListRolesResponse',
            'ListRolesForUserRequest' => '\\StructType\\ListRolesForUserRequest',
            'ListRolesForUserResponse' => '\\StructType\\ListRolesForUserResponse',
            'ListRolesForUserByUpnRequest' => '\\StructType\\ListRolesForUserByUpnRequest',
            'ListRolesForUserByUpnResponse' => '\\StructType\\ListRolesForUserByUpnResponse',
            'AddRoleMembersRequest' => '\\StructType\\AddRoleMembersRequest',
            'RoleMemberNotFoundException' => '\\StructType\\RoleMemberNotFoundException',
            'AddRoleMembersByRoleNameRequest' => '\\StructType\\AddRoleMembersByRoleNameRequest',
            'RemoveRoleMembersRequest' => '\\StructType\\RemoveRoleMembersRequest',
            'RemoveSelfFromRoleException' => '\\StructType\\RemoveSelfFromRoleException',
            'RoleUsabilityViolationException' => '\\StructType\\RoleUsabilityViolationException',
            'RemoveRoleMembersByRoleNameRequest' => '\\StructType\\RemoveRoleMembersByRoleNameRequest',
            'ListRoleMembersRequest' => '\\StructType\\ListRoleMembersRequest',
            'ListRoleMembersResponse' => '\\StructType\\ListRoleMembersResponse',
            'NavigateRoleMemberResultsRequest' => '\\StructType\\NavigateRoleMemberResultsRequest',
            'NavigateRoleMemberResultsResponse' => '\\StructType\\NavigateRoleMemberResultsResponse',
            'AddForeignGroupToRoleRequest' => '\\StructType\\AddForeignGroupToRoleRequest',
            'RemoveForeignGroupFromRoleRequest' => '\\StructType\\RemoveForeignGroupFromRoleRequest',
            'RemoveFromRoleNotAllowedException' => '\\StructType\\RemoveFromRoleNotAllowedException',
            'AddRoleScopedMembersRequest' => '\\StructType\\AddRoleScopedMembersRequest',
            'RemoveRoleScopedMembersRequest' => '\\StructType\\RemoveRoleScopedMembersRequest',
            'ListRoleScopedMembersRequest' => '\\StructType\\ListRoleScopedMembersRequest',
            'ListRoleScopedMembersResponse' => '\\StructType\\ListRoleScopedMembersResponse',
            'NavigateRoleScopedMemberResultsRequest' => '\\StructType\\NavigateRoleScopedMemberResultsRequest',
            'NavigateRoleScopedMemberResultsResponse' => '\\StructType\\NavigateRoleScopedMemberResultsResponse',
            'AddUserRequest' => '\\StructType\\AddUserRequest',
            'AddUserResponse' => '\\StructType\\AddUserResponse',
            'InvalidPasswordContainMemberNameException' => '\\StructType\\InvalidPasswordContainMemberNameException',
            'InvalidPasswordException' => '\\StructType\\InvalidPasswordException',
            'InvalidLicenseConfigurationException' => '\\StructType\\InvalidLicenseConfigurationException',
            'InvalidUserLicenseOptionException' => '\\StructType\\InvalidUserLicenseOptionException',
            'InvalidSubscriptionStatusException' => '\\StructType\\InvalidSubscriptionStatusException',
            'InvalidUserLicenseException' => '\\StructType\\InvalidUserLicenseException',
            'LicenseQuotaExceededException' => '\\StructType\\LicenseQuotaExceededException',
            'IncorrectPasswordException' => '\\StructType\\IncorrectPasswordException',
            'InvalidPasswordWeakException' => '\\StructType\\InvalidPasswordWeakException',
            'PropertyDomainValidationException' => '\\StructType\\PropertyDomainValidationException',
            'UserAlreadyExistsException' => '\\StructType\\UserAlreadyExistsException',
            'IdentityUserInRecycleStateException' => '\\StructType\\IdentityUserInRecycleStateException',
            'TooManyMappedTenantsException' => '\\StructType\\TooManyMappedTenantsException',
            'RemoveUserRequest' => '\\StructType\\RemoveUserRequest',
            'UserRemoveSelfException' => '\\StructType\\UserRemoveSelfException',
            'RemoveUserByUpnRequest' => '\\StructType\\RemoveUserByUpnRequest',
            'RemoveDirSyncObjectNotAllowedException' => '\\StructType\\RemoveDirSyncObjectNotAllowedException',
            'SetUserRequest' => '\\StructType\\SetUserRequest',
            'ChangeUserPrincipalNameRequest' => '\\StructType\\ChangeUserPrincipalNameRequest',
            'ChangeUserPrincipalNameResponse' => '\\StructType\\ChangeUserPrincipalNameResponse',
            'ChangeUserPrincipalNameByUpnRequest' => '\\StructType\\ChangeUserPrincipalNameByUpnRequest',
            'ChangeUserPrincipalNameByUpnResponse' => '\\StructType\\ChangeUserPrincipalNameByUpnResponse',
            'ResetUserPasswordRequest' => '\\StructType\\ResetUserPasswordRequest',
            'ResetUserPasswordResponse' => '\\StructType\\ResetUserPasswordResponse',
            'UserConflictAuthenticationException' => '\\StructType\\UserConflictAuthenticationException',
            'ResetUserPasswordByUpnRequest' => '\\StructType\\ResetUserPasswordByUpnRequest',
            'ResetUserPasswordByUpnResponse' => '\\StructType\\ResetUserPasswordByUpnResponse',
            'GetUserRequest' => '\\StructType\\GetUserRequest',
            'GetUserResponse' => '\\StructType\\GetUserResponse',
            'GetUserByUpnRequest' => '\\StructType\\GetUserByUpnRequest',
            'GetUserByUpnResponse' => '\\StructType\\GetUserByUpnResponse',
            'GetUserByLiveIdRequest' => '\\StructType\\GetUserByLiveIdRequest',
            'GetUserByLiveIdResponse' => '\\StructType\\GetUserByLiveIdResponse',
            'ListUsersRequest' => '\\StructType\\ListUsersRequest',
            'ListUsersResponse' => '\\StructType\\ListUsersResponse',
            'ListUsersByStrongAuthenticationRequest' => '\\StructType\\ListUsersByStrongAuthenticationRequest',
            'ListUsersByStrongAuthenticationResponse' => '\\StructType\\ListUsersByStrongAuthenticationResponse',
            'NavigateUserResultsRequest' => '\\StructType\\NavigateUserResultsRequest',
            'NavigateUserResultsResponse' => '\\StructType\\NavigateUserResultsResponse',
            'SetUserLicensesRequest' => '\\StructType\\SetUserLicensesRequest',
            'SetUserLicensesByUpnRequest' => '\\StructType\\SetUserLicensesByUpnRequest',
            'RetryUserProvisioningRequest' => '\\StructType\\RetryUserProvisioningRequest',
            'ConvertFederatedUserToManagedRequest' => '\\StructType\\ConvertFederatedUserToManagedRequest',
            'ConvertFederatedUserToManagedResponse' => '\\StructType\\ConvertFederatedUserToManagedResponse',
            'UserAuthenticationUnchangedException' => '\\StructType\\UserAuthenticationUnchangedException',
            'RestoreUserRequest' => '\\StructType\\RestoreUserRequest',
            'RestoreUserResponse' => '\\StructType\\RestoreUserResponse',
            'RestoreUserErrorException' => '\\StructType\\RestoreUserErrorException',
            'RestoreUserLicenseErrorException' => '\\StructType\\RestoreUserLicenseErrorException',
            'RestoreUserNotAllowedException' => '\\StructType\\RestoreUserNotAllowedException',
            'RestoreUserByUpnRequest' => '\\StructType\\RestoreUserByUpnRequest',
            'RestoreUserByUpnResponse' => '\\StructType\\RestoreUserByUpnResponse',
            'ResetStrongAuthenticationMethodByUpnRequest' => '\\StructType\\ResetStrongAuthenticationMethodByUpnRequest',
            'DeleteApplicationPasswordRequest' => '\\StructType\\DeleteApplicationPasswordRequest',
            'AddServicePrincipalRequest' => '\\StructType\\AddServicePrincipalRequest',
            'AddServicePrincipalResponse' => '\\StructType\\AddServicePrincipalResponse',
            'ConcurrencyException' => '\\StructType\\ConcurrencyException',
            'AddServicePrincipalCredentialsRequest' => '\\StructType\\AddServicePrincipalCredentialsRequest',
            'ServicePrincipalCredentialNotSettableException' => '\\StructType\\ServicePrincipalCredentialNotSettableException',
            'ServicePrincipalNotFoundException' => '\\StructType\\ServicePrincipalNotFoundException',
            'AddServicePrincipalCredentialsBySpnRequest' => '\\StructType\\AddServicePrincipalCredentialsBySpnRequest',
            'AddServicePrincipalCredentialsByAppPrincipalIdRequest' => '\\StructType\\AddServicePrincipalCredentialsByAppPrincipalIdRequest',
            'RemoveServicePrincipalRequest' => '\\StructType\\RemoveServicePrincipalRequest',
            'RemoveServicePrincipalByAppPrincipalIdRequest' => '\\StructType\\RemoveServicePrincipalByAppPrincipalIdRequest',
            'RemoveServicePrincipalBySpnRequest' => '\\StructType\\RemoveServicePrincipalBySpnRequest',
            'GetServicePrincipalRequest' => '\\StructType\\GetServicePrincipalRequest',
            'GetServicePrincipalResponse' => '\\StructType\\GetServicePrincipalResponse',
            'GetServicePrincipalByAppPrincipalIdRequest' => '\\StructType\\GetServicePrincipalByAppPrincipalIdRequest',
            'GetServicePrincipalByAppPrincipalIdResponse' => '\\StructType\\GetServicePrincipalByAppPrincipalIdResponse',
            'GetServicePrincipalBySpnRequest' => '\\StructType\\GetServicePrincipalBySpnRequest',
            'GetServicePrincipalBySpnResponse' => '\\StructType\\GetServicePrincipalBySpnResponse',
            'RemoveServicePrincipalCredentialsRequest' => '\\StructType\\RemoveServicePrincipalCredentialsRequest',
            'KeyNotFoundException' => '\\StructType\\KeyNotFoundException',
            'RemoveServicePrincipalCredentialsBySpnRequest' => '\\StructType\\RemoveServicePrincipalCredentialsBySpnRequest',
            'RemoveServicePrincipalCredentialsByAppPrincipalIdRequest' => '\\StructType\\RemoveServicePrincipalCredentialsByAppPrincipalIdRequest',
            'SetServicePrincipalRequest' => '\\StructType\\SetServicePrincipalRequest',
            'ListServicePrincipalsRequest' => '\\StructType\\ListServicePrincipalsRequest',
            'ListServicePrincipalsResponse' => '\\StructType\\ListServicePrincipalsResponse',
            'NavigateServicePrincipalResultsRequest' => '\\StructType\\NavigateServicePrincipalResultsRequest',
            'NavigateServicePrincipalResultsResponse' => '\\StructType\\NavigateServicePrincipalResultsResponse',
            'ListServicePrincipalCredentialsRequest' => '\\StructType\\ListServicePrincipalCredentialsRequest',
            'ListServicePrincipalCredentialsResponse' => '\\StructType\\ListServicePrincipalCredentialsResponse',
            'ListServicePrincipalCredentialsByAppPrincipalIdRequest' => '\\StructType\\ListServicePrincipalCredentialsByAppPrincipalIdRequest',
            'ListServicePrincipalCredentialsByAppPrincipalIdResponse' => '\\StructType\\ListServicePrincipalCredentialsByAppPrincipalIdResponse',
            'ListServicePrincipalCredentialsBySpnRequest' => '\\StructType\\ListServicePrincipalCredentialsBySpnRequest',
            'ListServicePrincipalCredentialsBySpnResponse' => '\\StructType\\ListServicePrincipalCredentialsBySpnResponse',
            'GetHeaderInfo' => '\\StructType\\GetHeaderInfo',
            'GetServiceStatus' => '\\StructType\\GetServiceStatus',
            'GetServiceStatusResponse' => '\\StructType\\GetServiceStatusResponse',
            'MsolConnect' => '\\StructType\\MsolConnect',
            'GetPartnerInformation' => '\\StructType\\GetPartnerInformation',
            'AddAdministrativeUnit' => '\\StructType\\AddAdministrativeUnit',
            'GetAdministrativeUnit' => '\\StructType\\GetAdministrativeUnit',
            'SetAdministrativeUnit' => '\\StructType\\SetAdministrativeUnit',
            'SetAdministrativeUnitResponse' => '\\StructType\\SetAdministrativeUnitResponse',
            'RemoveAdministrativeUnit' => '\\StructType\\RemoveAdministrativeUnit',
            'RemoveAdministrativeUnitResponse' => '\\StructType\\RemoveAdministrativeUnitResponse',
            'ListAdministrativeUnits' => '\\StructType\\ListAdministrativeUnits',
            'NavigateAdministrativeUnitResults' => '\\StructType\\NavigateAdministrativeUnitResults',
            'AddAdministrativeUnitMembers' => '\\StructType\\AddAdministrativeUnitMembers',
            'AddAdministrativeUnitMembersResponse' => '\\StructType\\AddAdministrativeUnitMembersResponse',
            'RemoveAdministrativeUnitMembers' => '\\StructType\\RemoveAdministrativeUnitMembers',
            'RemoveAdministrativeUnitMembersResponse' => '\\StructType\\RemoveAdministrativeUnitMembersResponse',
            'ListAdministrativeUnitMembers' => '\\StructType\\ListAdministrativeUnitMembers',
            'NavigateAdministrativeUnitMemberResults' => '\\StructType\\NavigateAdministrativeUnitMemberResults',
            'GetCompanyInformation' => '\\StructType\\GetCompanyInformation',
            'GetSubscription' => '\\StructType\\GetSubscription',
            'ListSubscriptions' => '\\StructType\\ListSubscriptions',
            'ListAccountSkus' => '\\StructType\\ListAccountSkus',
            'SetPartnerInformation' => '\\StructType\\SetPartnerInformation',
            'SetPartnerInformationResponse' => '\\StructType\\SetPartnerInformationResponse',
            'SetCompanyContactInformation' => '\\StructType\\SetCompanyContactInformation',
            'SetCompanyContactInformationResponse' => '\\StructType\\SetCompanyContactInformationResponse',
            'SetCompanySecurityComplianceContactInformation' => '\\StructType\\SetCompanySecurityComplianceContactInformation',
            'SetCompanySecurityComplianceContactInformationResponse' => '\\StructType\\SetCompanySecurityComplianceContactInformationResponse',
            'SetCompanyDirSyncEnabled' => '\\StructType\\SetCompanyDirSyncEnabled',
            'SetCompanyDirSyncEnabledResponse' => '\\StructType\\SetCompanyDirSyncEnabledResponse',
            'SetAccidentalDeletionThreshold' => '\\StructType\\SetAccidentalDeletionThreshold',
            'SetAccidentalDeletionThresholdResponse' => '\\StructType\\SetAccidentalDeletionThresholdResponse',
            'GetAccidentalDeletionInformation' => '\\StructType\\GetAccidentalDeletionInformation',
            'SetCompanyDirSyncFeature' => '\\StructType\\SetCompanyDirSyncFeature',
            'SetCompanyDirSyncFeatureResponse' => '\\StructType\\SetCompanyDirSyncFeatureResponse',
            'GetCompanyDirSyncFeatures' => '\\StructType\\GetCompanyDirSyncFeatures',
            'SetCompanyPasswordSyncEnabled' => '\\StructType\\SetCompanyPasswordSyncEnabled',
            'SetCompanyPasswordSyncEnabledResponse' => '\\StructType\\SetCompanyPasswordSyncEnabledResponse',
            'SetCompanySettings' => '\\StructType\\SetCompanySettings',
            'SetCompanySettingsResponse' => '\\StructType\\SetCompanySettingsResponse',
            'ListPartnerContracts' => '\\StructType\\ListPartnerContracts',
            'NavigatePartnerContracts' => '\\StructType\\NavigatePartnerContracts',
            'GetPasswordPolicy' => '\\StructType\\GetPasswordPolicy',
            'SetPasswordPolicy' => '\\StructType\\SetPasswordPolicy',
            'SetPasswordPolicyResponse' => '\\StructType\\SetPasswordPolicyResponse',
            'ListDirSyncProvisioningErrors' => '\\StructType\\ListDirSyncProvisioningErrors',
            'NavigateDirSyncProvisioningErrors' => '\\StructType\\NavigateDirSyncProvisioningErrors',
            'HasObjectsWithDirSyncProvisioningErrors' => '\\StructType\\HasObjectsWithDirSyncProvisioningErrors',
            'HasObjectsWithDirSyncProvisioningErrors2' => '\\StructType\\HasObjectsWithDirSyncProvisioningErrors2',
            'UpdateDirSyncProvisioningError' => '\\StructType\\UpdateDirSyncProvisioningError',
            'UpdateDirSyncProvisioningErrorResponse' => '\\StructType\\UpdateDirSyncProvisioningErrorResponse',
            'SetCompanyMultiNationalEnabled' => '\\StructType\\SetCompanyMultiNationalEnabled',
            'SetCompanyMultiNationalEnabledResponse' => '\\StructType\\SetCompanyMultiNationalEnabledResponse',
            'SetCompanyAllowedDataLocation' => '\\StructType\\SetCompanyAllowedDataLocation',
            'SetCompanyAllowedDataLocationResponse' => '\\StructType\\SetCompanyAllowedDataLocationResponse',
            'GetCompanyAllowedDataLocation' => '\\StructType\\GetCompanyAllowedDataLocation',
            'RemoveContact' => '\\StructType\\RemoveContact',
            'RemoveContactResponse' => '\\StructType\\RemoveContactResponse',
            'GetContact' => '\\StructType\\GetContact',
            'ListContacts' => '\\StructType\\ListContacts',
            'NavigateContactResults' => '\\StructType\\NavigateContactResults',
            'RetryContactProvisioning' => '\\StructType\\RetryContactProvisioning',
            'RetryContactProvisioningResponse' => '\\StructType\\RetryContactProvisioningResponse',
            'AddDomain' => '\\StructType\\AddDomain',
            'VerifyDomain' => '\\StructType\\VerifyDomain',
            'VerifyDomainResponse' => '\\StructType\\VerifyDomainResponse',
            'VerifyDomain2' => '\\StructType\\VerifyDomain2',
            'VerifyEmailVerifiedDomain' => '\\StructType\\VerifyEmailVerifiedDomain',
            'RemoveDomain' => '\\StructType\\RemoveDomain',
            'RemoveDomainResponse' => '\\StructType\\RemoveDomainResponse',
            'SetDomain' => '\\StructType\\SetDomain',
            'SetDomainResponse' => '\\StructType\\SetDomainResponse',
            'SetDomainAuthentication' => '\\StructType\\SetDomainAuthentication',
            'SetDomainAuthenticationResponse' => '\\StructType\\SetDomainAuthenticationResponse',
            'GetDomainFederationSettings' => '\\StructType\\GetDomainFederationSettings',
            'SetDomainFederationSettings' => '\\StructType\\SetDomainFederationSettings',
            'SetDomainFederationSettingsResponse' => '\\StructType\\SetDomainFederationSettingsResponse',
            'GetDomain' => '\\StructType\\GetDomain',
            'ListDomains' => '\\StructType\\ListDomains',
            'GetDomainVerificationDns' => '\\StructType\\GetDomainVerificationDns',
            'AddGroup' => '\\StructType\\AddGroup',
            'AddWellKnownGroup' => '\\StructType\\AddWellKnownGroup',
            'RemoveGroup' => '\\StructType\\RemoveGroup',
            'RemoveGroupResponse' => '\\StructType\\RemoveGroupResponse',
            'SetGroup' => '\\StructType\\SetGroup',
            'SetGroupResponse' => '\\StructType\\SetGroupResponse',
            'GetGroup' => '\\StructType\\GetGroup',
            'ListGroups' => '\\StructType\\ListGroups',
            'NavigateGroupResults' => '\\StructType\\NavigateGroupResults',
            'AddGroupMembers' => '\\StructType\\AddGroupMembers',
            'AddGroupMembersResponse' => '\\StructType\\AddGroupMembersResponse',
            'RemoveGroupMembers' => '\\StructType\\RemoveGroupMembers',
            'RemoveGroupMembersResponse' => '\\StructType\\RemoveGroupMembersResponse',
            'ListGroupMembers' => '\\StructType\\ListGroupMembers',
            'NavigateGroupMemberResults' => '\\StructType\\NavigateGroupMemberResults',
            'RetryGroupProvisioning' => '\\StructType\\RetryGroupProvisioning',
            'RetryGroupProvisioningResponse' => '\\StructType\\RetryGroupProvisioningResponse',
            'GetRole' => '\\StructType\\GetRole',
            'GetRoleByName' => '\\StructType\\GetRoleByName',
            'ListRoles' => '\\StructType\\ListRoles',
            'ListRolesForUser' => '\\StructType\\ListRolesForUser',
            'ListRolesForUserByUpn' => '\\StructType\\ListRolesForUserByUpn',
            'AddRoleMembers' => '\\StructType\\AddRoleMembers',
            'AddRoleMembersResponse' => '\\StructType\\AddRoleMembersResponse',
            'AddRoleMembersByRoleName' => '\\StructType\\AddRoleMembersByRoleName',
            'AddRoleMembersByRoleNameResponse' => '\\StructType\\AddRoleMembersByRoleNameResponse',
            'RemoveRoleMembers' => '\\StructType\\RemoveRoleMembers',
            'RemoveRoleMembersResponse' => '\\StructType\\RemoveRoleMembersResponse',
            'RemoveRoleMembersByRoleName' => '\\StructType\\RemoveRoleMembersByRoleName',
            'RemoveRoleMembersByRoleNameResponse' => '\\StructType\\RemoveRoleMembersByRoleNameResponse',
            'ListRoleMembers' => '\\StructType\\ListRoleMembers',
            'NavigateRoleMemberResults' => '\\StructType\\NavigateRoleMemberResults',
            'AddForeignGroupToRole' => '\\StructType\\AddForeignGroupToRole',
            'AddForeignGroupToRoleResponse' => '\\StructType\\AddForeignGroupToRoleResponse',
            'RemoveForeignGroupFromRole' => '\\StructType\\RemoveForeignGroupFromRole',
            'RemoveForeignGroupFromRoleResponse' => '\\StructType\\RemoveForeignGroupFromRoleResponse',
            'AddRoleScopedMembers' => '\\StructType\\AddRoleScopedMembers',
            'AddRoleScopedMembersResponse' => '\\StructType\\AddRoleScopedMembersResponse',
            'RemoveRoleScopedMembers' => '\\StructType\\RemoveRoleScopedMembers',
            'RemoveRoleScopedMembersResponse' => '\\StructType\\RemoveRoleScopedMembersResponse',
            'ListRoleScopedMembers' => '\\StructType\\ListRoleScopedMembers',
            'NavigateRoleScopedMemberResults' => '\\StructType\\NavigateRoleScopedMemberResults',
            'AddUser' => '\\StructType\\AddUser',
            'RemoveUser' => '\\StructType\\RemoveUser',
            'RemoveUserResponse' => '\\StructType\\RemoveUserResponse',
            'RemoveUserByUpn' => '\\StructType\\RemoveUserByUpn',
            'RemoveUserByUpnResponse' => '\\StructType\\RemoveUserByUpnResponse',
            'SetUser' => '\\StructType\\SetUser',
            'SetUserResponse' => '\\StructType\\SetUserResponse',
            'ChangeUserPrincipalName' => '\\StructType\\ChangeUserPrincipalName',
            'ChangeUserPrincipalNameByUpn' => '\\StructType\\ChangeUserPrincipalNameByUpn',
            'ResetUserPassword' => '\\StructType\\ResetUserPassword',
            'ResetUserPasswordByUpn' => '\\StructType\\ResetUserPasswordByUpn',
            'GetUser' => '\\StructType\\GetUser',
            'GetUserByUpn' => '\\StructType\\GetUserByUpn',
            'GetUserByLiveId' => '\\StructType\\GetUserByLiveId',
            'ListUsers' => '\\StructType\\ListUsers',
            'ListUsersByStrongAuthentication' => '\\StructType\\ListUsersByStrongAuthentication',
            'NavigateUserResults' => '\\StructType\\NavigateUserResults',
            'SetUserLicenses' => '\\StructType\\SetUserLicenses',
            'SetUserLicensesResponse' => '\\StructType\\SetUserLicensesResponse',
            'SetUserLicensesByUpn' => '\\StructType\\SetUserLicensesByUpn',
            'SetUserLicensesByUpnResponse' => '\\StructType\\SetUserLicensesByUpnResponse',
            'RetryUserProvisioning' => '\\StructType\\RetryUserProvisioning',
            'RetryUserProvisioningResponse' => '\\StructType\\RetryUserProvisioningResponse',
            'ConvertFederatedUserToManaged' => '\\StructType\\ConvertFederatedUserToManaged',
            'RestoreUser' => '\\StructType\\RestoreUser',
            'RestoreUserByUpn' => '\\StructType\\RestoreUserByUpn',
            'ResetStrongAuthenticationMethodByUpn' => '\\StructType\\ResetStrongAuthenticationMethodByUpn',
            'ResetStrongAuthenticationMethodByUpnResponse' => '\\StructType\\ResetStrongAuthenticationMethodByUpnResponse',
            'DeleteApplicationPassword' => '\\StructType\\DeleteApplicationPassword',
            'DeleteApplicationPasswordResponse' => '\\StructType\\DeleteApplicationPasswordResponse',
            'AddServicePrincipal' => '\\StructType\\AddServicePrincipal',
            'AddServicePrincipalCredentials' => '\\StructType\\AddServicePrincipalCredentials',
            'AddServicePrincipalCredentialsResponse' => '\\StructType\\AddServicePrincipalCredentialsResponse',
            'AddServicePrincipalCredentialsBySpn' => '\\StructType\\AddServicePrincipalCredentialsBySpn',
            'AddServicePrincipalCredentialsBySpnResponse' => '\\StructType\\AddServicePrincipalCredentialsBySpnResponse',
            'AddServicePrincipalCredentialsByAppPrincipalId' => '\\StructType\\AddServicePrincipalCredentialsByAppPrincipalId',
            'AddServicePrincipalCredentialsByAppPrincipalIdResponse' => '\\StructType\\AddServicePrincipalCredentialsByAppPrincipalIdResponse',
            'RemoveServicePrincipal' => '\\StructType\\RemoveServicePrincipal',
            'RemoveServicePrincipalResponse' => '\\StructType\\RemoveServicePrincipalResponse',
            'RemoveServicePrincipalByAppPrincipalId' => '\\StructType\\RemoveServicePrincipalByAppPrincipalId',
            'RemoveServicePrincipalByAppPrincipalIdResponse' => '\\StructType\\RemoveServicePrincipalByAppPrincipalIdResponse',
            'RemoveServicePrincipalBySpn' => '\\StructType\\RemoveServicePrincipalBySpn',
            'RemoveServicePrincipalBySpnResponse' => '\\StructType\\RemoveServicePrincipalBySpnResponse',
            'GetServicePrincipal' => '\\StructType\\GetServicePrincipal',
            'GetServicePrincipalByAppPrincipalId' => '\\StructType\\GetServicePrincipalByAppPrincipalId',
            'GetServicePrincipalBySpn' => '\\StructType\\GetServicePrincipalBySpn',
            'RemoveServicePrincipalCredentials' => '\\StructType\\RemoveServicePrincipalCredentials',
            'RemoveServicePrincipalCredentialsResponse' => '\\StructType\\RemoveServicePrincipalCredentialsResponse',
            'RemoveServicePrincipalCredentialsBySpn' => '\\StructType\\RemoveServicePrincipalCredentialsBySpn',
            'RemoveServicePrincipalCredentialsBySpnResponse' => '\\StructType\\RemoveServicePrincipalCredentialsBySpnResponse',
            'RemoveServicePrincipalCredentialsByAppPrincipalId' => '\\StructType\\RemoveServicePrincipalCredentialsByAppPrincipalId',
            'RemoveServicePrincipalCredentialsByAppPrincipalIdResponse' => '\\StructType\\RemoveServicePrincipalCredentialsByAppPrincipalIdResponse',
            'SetServicePrincipal' => '\\StructType\\SetServicePrincipal',
            'SetServicePrincipalResponse' => '\\StructType\\SetServicePrincipalResponse',
            'ListServicePrincipals' => '\\StructType\\ListServicePrincipals',
            'NavigateServicePrincipalResults' => '\\StructType\\NavigateServicePrincipalResults',
            'ListServicePrincipalCredentials' => '\\StructType\\ListServicePrincipalCredentials',
            'ListServicePrincipalCredentialsByAppPrincipalId' => '\\StructType\\ListServicePrincipalCredentialsByAppPrincipalId',
            'ListServicePrincipalCredentialsBySpn' => '\\StructType\\ListServicePrincipalCredentialsBySpn',
            'NetworkSyntheticFault' => '\\StructType\\NetworkSyntheticFault',
            'InvalidOperationException' => '\\StructType\\InvalidOperationException',
            'SystemException' => '\\StructType\\SystemException',
            'Exception' => '\\StructType\\Exception',
        );
    }
}
