<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfXElement ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfXElement
 * @subpackage Arrays
 */
class ArrayOfXElement extends AbstractStructArrayBase
{
    /**
     * The XElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XElement[]
     */
    public $XElement;
    /**
     * Constructor method for ArrayOfXElement
     * @uses ArrayOfXElement::setXElement()
     * @param \StructType\XElement[] $xElement
     */
    public function __construct(array $xElement = array())
    {
        $this
            ->setXElement($xElement);
    }
    /**
     * Get XElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XElement[]|null
     */
    public function getXElement()
    {
        return isset($this->XElement) ? $this->XElement : null;
    }
    /**
     * Set XElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\XElement[] $xElement
     * @return \ArrayType\ArrayOfXElement
     */
    public function setXElement(array $xElement = array())
    {
        foreach ($xElement as $arrayOfXElementXElementItem) {
            // validation for constraint: itemType
            if (!$arrayOfXElementXElementItem instanceof \StructType\XElement) {
                throw new \InvalidArgumentException(sprintf('The XElement property can only contain items of \StructType\XElement, "%s" given', is_object($arrayOfXElementXElementItem) ? get_class($arrayOfXElementXElementItem) : gettype($arrayOfXElementXElementItem)), __LINE__);
            }
        }
        if (is_null($xElement) || (is_array($xElement) && empty($xElement))) {
            unset($this->XElement);
        } else {
            $this->XElement = $xElement;
        }
        return $this;
    }
    /**
     * Add item to XElement value
     * @throws \InvalidArgumentException
     * @param \StructType\XElement $item
     * @return \ArrayType\ArrayOfXElement
     */
    public function addToXElement(\StructType\XElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XElement) {
            throw new \InvalidArgumentException(sprintf('The XElement property can only contain items of \StructType\XElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->XElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\XElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\XElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\XElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\XElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\XElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string XElement
     */
    public function getAttributeName()
    {
        return 'XElement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfXElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
