<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRole ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRole
 * @subpackage Arrays
 */
class ArrayOfRole extends AbstractStructArrayBase
{
    /**
     * The Role
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Role[]
     */
    public $Role;
    /**
     * Constructor method for ArrayOfRole
     * @uses ArrayOfRole::setRole()
     * @param \StructType\Role[] $role
     */
    public function __construct(array $role = array())
    {
        $this
            ->setRole($role);
    }
    /**
     * Get Role value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Role[]|null
     */
    public function getRole()
    {
        return isset($this->Role) ? $this->Role : null;
    }
    /**
     * Set Role value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Role[] $role
     * @return \ArrayType\ArrayOfRole
     */
    public function setRole(array $role = array())
    {
        foreach ($role as $arrayOfRoleRoleItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoleRoleItem instanceof \StructType\Role) {
                throw new \InvalidArgumentException(sprintf('The Role property can only contain items of \StructType\Role, "%s" given', is_object($arrayOfRoleRoleItem) ? get_class($arrayOfRoleRoleItem) : gettype($arrayOfRoleRoleItem)), __LINE__);
            }
        }
        if (is_null($role) || (is_array($role) && empty($role))) {
            unset($this->Role);
        } else {
            $this->Role = $role;
        }
        return $this;
    }
    /**
     * Add item to Role value
     * @throws \InvalidArgumentException
     * @param \StructType\Role $item
     * @return \ArrayType\ArrayOfRole
     */
    public function addToRole(\StructType\Role $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Role) {
            throw new \InvalidArgumentException(sprintf('The Role property can only contain items of \StructType\Role, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Role[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Role|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Role|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Role|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Role|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Role|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Role
     */
    public function getAttributeName()
    {
        return 'Role';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRole
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
