<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAuthorizedService ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAuthorizedService
 * @subpackage Arrays
 */
class ArrayOfAuthorizedService extends AbstractStructArrayBase
{
    /**
     * The AuthorizedService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AuthorizedService;
    /**
     * Constructor method for ArrayOfAuthorizedService
     * @uses ArrayOfAuthorizedService::setAuthorizedService()
     * @param string[] $authorizedService
     */
    public function __construct(array $authorizedService = array())
    {
        $this
            ->setAuthorizedService($authorizedService);
    }
    /**
     * Get AuthorizedService value
     * @return string[]|null
     */
    public function getAuthorizedService()
    {
        return $this->AuthorizedService;
    }
    /**
     * Set AuthorizedService value
     * @throws \InvalidArgumentException
     * @param string[] $authorizedService
     * @return \ArrayType\ArrayOfAuthorizedService
     */
    public function setAuthorizedService(array $authorizedService = array())
    {
        $invalidValues = array();
        foreach ($authorizedService as $arrayOfAuthorizedServiceAuthorizedServiceItem) {
            if (!\EnumType\AuthorizedService::valueIsValid($arrayOfAuthorizedServiceAuthorizedServiceItem)) {
                $invalidValues[] = var_export($arrayOfAuthorizedServiceAuthorizedServiceItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\AuthorizedService::getValidValues())), __LINE__);
        }
        $this->AuthorizedService = $authorizedService;
        return $this;
    }
    /**
     * Add item to AuthorizedService value
     * @uses \EnumType\AuthorizedService::valueIsValid()
     * @uses \EnumType\AuthorizedService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfAuthorizedService
     */
    public function addToAuthorizedService($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AuthorizedService::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AuthorizedService::getValidValues())), __LINE__);
        }
        $this->AuthorizedService[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\AuthorizedService::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfAuthorizedService
     */
    public function add($item)
    {
        if (!\EnumType\AuthorizedService::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AuthorizedService::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AuthorizedService
     */
    public function getAttributeName()
    {
        return 'AuthorizedService';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAuthorizedService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
