<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdministrativeUnit ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAdministrativeUnit
 * @subpackage Arrays
 */
class ArrayOfAdministrativeUnit extends AbstractStructArrayBase
{
    /**
     * The AdministrativeUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdministrativeUnit[]
     */
    public $AdministrativeUnit;
    /**
     * Constructor method for ArrayOfAdministrativeUnit
     * @uses ArrayOfAdministrativeUnit::setAdministrativeUnit()
     * @param \StructType\AdministrativeUnit[] $administrativeUnit
     */
    public function __construct(array $administrativeUnit = array())
    {
        $this
            ->setAdministrativeUnit($administrativeUnit);
    }
    /**
     * Get AdministrativeUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdministrativeUnit[]|null
     */
    public function getAdministrativeUnit()
    {
        return isset($this->AdministrativeUnit) ? $this->AdministrativeUnit : null;
    }
    /**
     * Set AdministrativeUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdministrativeUnit[] $administrativeUnit
     * @return \ArrayType\ArrayOfAdministrativeUnit
     */
    public function setAdministrativeUnit(array $administrativeUnit = array())
    {
        foreach ($administrativeUnit as $arrayOfAdministrativeUnitAdministrativeUnitItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdministrativeUnitAdministrativeUnitItem instanceof \StructType\AdministrativeUnit) {
                throw new \InvalidArgumentException(sprintf('The AdministrativeUnit property can only contain items of \StructType\AdministrativeUnit, "%s" given', is_object($arrayOfAdministrativeUnitAdministrativeUnitItem) ? get_class($arrayOfAdministrativeUnitAdministrativeUnitItem) : gettype($arrayOfAdministrativeUnitAdministrativeUnitItem)), __LINE__);
            }
        }
        if (is_null($administrativeUnit) || (is_array($administrativeUnit) && empty($administrativeUnit))) {
            unset($this->AdministrativeUnit);
        } else {
            $this->AdministrativeUnit = $administrativeUnit;
        }
        return $this;
    }
    /**
     * Add item to AdministrativeUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\AdministrativeUnit $item
     * @return \ArrayType\ArrayOfAdministrativeUnit
     */
    public function addToAdministrativeUnit(\StructType\AdministrativeUnit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdministrativeUnit) {
            throw new \InvalidArgumentException(sprintf('The AdministrativeUnit property can only contain items of \StructType\AdministrativeUnit, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdministrativeUnit[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AdministrativeUnit|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AdministrativeUnit|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AdministrativeUnit|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AdministrativeUnit|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AdministrativeUnit|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdministrativeUnit
     */
    public function getAttributeName()
    {
        return 'AdministrativeUnit';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAdministrativeUnit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
