<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserSearchDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UserSearchDefinition
 * @subpackage Structs
 */
class UserSearchDefinition extends SearchDefinition
{
    /**
     * The AccountSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountSkuIdentifier
     */
    public $AccountSku;
    /**
     * The AdministrativeUnitObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdministrativeUnitObjectId;
    /**
     * The BlackberryUsersOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BlackberryUsersOnly;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Department;
    /**
     * The DomainName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainName;
    /**
     * The EnabledFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnabledFilter;
    /**
     * The HasErrorsOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasErrorsOnly;
    /**
     * The IncludedProperties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $IncludedProperties;
    /**
     * The IndirectLicenseFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IndirectLicenseFilter
     */
    public $IndirectLicenseFilter;
    /**
     * The LicenseReconciliationNeededOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LicenseReconciliationNeededOnly;
    /**
     * The ReturnDeletedUsers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnDeletedUsers;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Synchronized
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Synchronized;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The UnlicensedUsersOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UnlicensedUsersOnly;
    /**
     * The UsageLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsageLocation;
    /**
     * Constructor method for UserSearchDefinition
     * @uses UserSearchDefinition::setAccountSku()
     * @uses UserSearchDefinition::setAdministrativeUnitObjectId()
     * @uses UserSearchDefinition::setBlackberryUsersOnly()
     * @uses UserSearchDefinition::setCity()
     * @uses UserSearchDefinition::setCountry()
     * @uses UserSearchDefinition::setDepartment()
     * @uses UserSearchDefinition::setDomainName()
     * @uses UserSearchDefinition::setEnabledFilter()
     * @uses UserSearchDefinition::setHasErrorsOnly()
     * @uses UserSearchDefinition::setIncludedProperties()
     * @uses UserSearchDefinition::setIndirectLicenseFilter()
     * @uses UserSearchDefinition::setLicenseReconciliationNeededOnly()
     * @uses UserSearchDefinition::setReturnDeletedUsers()
     * @uses UserSearchDefinition::setState()
     * @uses UserSearchDefinition::setSynchronized()
     * @uses UserSearchDefinition::setTitle()
     * @uses UserSearchDefinition::setUnlicensedUsersOnly()
     * @uses UserSearchDefinition::setUsageLocation()
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @param string $administrativeUnitObjectId
     * @param bool $blackberryUsersOnly
     * @param string $city
     * @param string $country
     * @param string $department
     * @param string $domainName
     * @param string $enabledFilter
     * @param bool $hasErrorsOnly
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @param \StructType\IndirectLicenseFilter $indirectLicenseFilter
     * @param bool $licenseReconciliationNeededOnly
     * @param bool $returnDeletedUsers
     * @param string $state
     * @param bool $synchronized
     * @param string $title
     * @param bool $unlicensedUsersOnly
     * @param string $usageLocation
     */
    public function __construct(\StructType\AccountSkuIdentifier $accountSku = null, $administrativeUnitObjectId = null, $blackberryUsersOnly = null, $city = null, $country = null, $department = null, $domainName = null, $enabledFilter = null, $hasErrorsOnly = null, \ArrayType\ArrayOfstring $includedProperties = null, \StructType\IndirectLicenseFilter $indirectLicenseFilter = null, $licenseReconciliationNeededOnly = null, $returnDeletedUsers = null, $state = null, $synchronized = null, $title = null, $unlicensedUsersOnly = null, $usageLocation = null)
    {
        $this
            ->setAccountSku($accountSku)
            ->setAdministrativeUnitObjectId($administrativeUnitObjectId)
            ->setBlackberryUsersOnly($blackberryUsersOnly)
            ->setCity($city)
            ->setCountry($country)
            ->setDepartment($department)
            ->setDomainName($domainName)
            ->setEnabledFilter($enabledFilter)
            ->setHasErrorsOnly($hasErrorsOnly)
            ->setIncludedProperties($includedProperties)
            ->setIndirectLicenseFilter($indirectLicenseFilter)
            ->setLicenseReconciliationNeededOnly($licenseReconciliationNeededOnly)
            ->setReturnDeletedUsers($returnDeletedUsers)
            ->setState($state)
            ->setSynchronized($synchronized)
            ->setTitle($title)
            ->setUnlicensedUsersOnly($unlicensedUsersOnly)
            ->setUsageLocation($usageLocation);
    }
    /**
     * Get AccountSku value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountSkuIdentifier|null
     */
    public function getAccountSku()
    {
        return isset($this->AccountSku) ? $this->AccountSku : null;
    }
    /**
     * Set AccountSku value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @return \StructType\UserSearchDefinition
     */
    public function setAccountSku(\StructType\AccountSkuIdentifier $accountSku = null)
    {
        if (is_null($accountSku) || (is_array($accountSku) && empty($accountSku))) {
            unset($this->AccountSku);
        } else {
            $this->AccountSku = $accountSku;
        }
        return $this;
    }
    /**
     * Get AdministrativeUnitObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdministrativeUnitObjectId()
    {
        return isset($this->AdministrativeUnitObjectId) ? $this->AdministrativeUnitObjectId : null;
    }
    /**
     * Set AdministrativeUnitObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $administrativeUnitObjectId
     * @return \StructType\UserSearchDefinition
     */
    public function setAdministrativeUnitObjectId($administrativeUnitObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($administrativeUnitObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($administrativeUnitObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($administrativeUnitObjectId) && !is_string($administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($administrativeUnitObjectId)), __LINE__);
        }
        if (is_null($administrativeUnitObjectId) || (is_array($administrativeUnitObjectId) && empty($administrativeUnitObjectId))) {
            unset($this->AdministrativeUnitObjectId);
        } else {
            $this->AdministrativeUnitObjectId = $administrativeUnitObjectId;
        }
        return $this;
    }
    /**
     * Get BlackberryUsersOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBlackberryUsersOnly()
    {
        return isset($this->BlackberryUsersOnly) ? $this->BlackberryUsersOnly : null;
    }
    /**
     * Set BlackberryUsersOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $blackberryUsersOnly
     * @return \StructType\UserSearchDefinition
     */
    public function setBlackberryUsersOnly($blackberryUsersOnly = null)
    {
        if (is_null($blackberryUsersOnly) || (is_array($blackberryUsersOnly) && empty($blackberryUsersOnly))) {
            unset($this->BlackberryUsersOnly);
        } else {
            $this->BlackberryUsersOnly = $blackberryUsersOnly;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\UserSearchDefinition
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\UserSearchDefinition
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get Department value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartment()
    {
        return isset($this->Department) ? $this->Department : null;
    }
    /**
     * Set Department value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $department
     * @return \StructType\UserSearchDefinition
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        if (is_null($department) || (is_array($department) && empty($department))) {
            unset($this->Department);
        } else {
            $this->Department = $department;
        }
        return $this;
    }
    /**
     * Get DomainName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->DomainName) ? $this->DomainName : null;
    }
    /**
     * Set DomainName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainName
     * @return \StructType\UserSearchDefinition
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->DomainName);
        } else {
            $this->DomainName = $domainName;
        }
        return $this;
    }
    /**
     * Get EnabledFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnabledFilter()
    {
        return isset($this->EnabledFilter) ? $this->EnabledFilter : null;
    }
    /**
     * Set EnabledFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\UserEnabledFilter::valueIsValid()
     * @uses \EnumType\UserEnabledFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $enabledFilter
     * @return \StructType\UserSearchDefinition
     */
    public function setEnabledFilter($enabledFilter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserEnabledFilter::valueIsValid($enabledFilter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $enabledFilter, implode(', ', \EnumType\UserEnabledFilter::getValidValues())), __LINE__);
        }
        if (is_null($enabledFilter) || (is_array($enabledFilter) && empty($enabledFilter))) {
            unset($this->EnabledFilter);
        } else {
            $this->EnabledFilter = $enabledFilter;
        }
        return $this;
    }
    /**
     * Get HasErrorsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasErrorsOnly()
    {
        return isset($this->HasErrorsOnly) ? $this->HasErrorsOnly : null;
    }
    /**
     * Set HasErrorsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasErrorsOnly
     * @return \StructType\UserSearchDefinition
     */
    public function setHasErrorsOnly($hasErrorsOnly = null)
    {
        if (is_null($hasErrorsOnly) || (is_array($hasErrorsOnly) && empty($hasErrorsOnly))) {
            unset($this->HasErrorsOnly);
        } else {
            $this->HasErrorsOnly = $hasErrorsOnly;
        }
        return $this;
    }
    /**
     * Get IncludedProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getIncludedProperties()
    {
        return isset($this->IncludedProperties) ? $this->IncludedProperties : null;
    }
    /**
     * Set IncludedProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @return \StructType\UserSearchDefinition
     */
    public function setIncludedProperties(\ArrayType\ArrayOfstring $includedProperties = null)
    {
        if (is_null($includedProperties) || (is_array($includedProperties) && empty($includedProperties))) {
            unset($this->IncludedProperties);
        } else {
            $this->IncludedProperties = $includedProperties;
        }
        return $this;
    }
    /**
     * Get IndirectLicenseFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IndirectLicenseFilter|null
     */
    public function getIndirectLicenseFilter()
    {
        return isset($this->IndirectLicenseFilter) ? $this->IndirectLicenseFilter : null;
    }
    /**
     * Set IndirectLicenseFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IndirectLicenseFilter $indirectLicenseFilter
     * @return \StructType\UserSearchDefinition
     */
    public function setIndirectLicenseFilter(\StructType\IndirectLicenseFilter $indirectLicenseFilter = null)
    {
        if (is_null($indirectLicenseFilter) || (is_array($indirectLicenseFilter) && empty($indirectLicenseFilter))) {
            unset($this->IndirectLicenseFilter);
        } else {
            $this->IndirectLicenseFilter = $indirectLicenseFilter;
        }
        return $this;
    }
    /**
     * Get LicenseReconciliationNeededOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLicenseReconciliationNeededOnly()
    {
        return isset($this->LicenseReconciliationNeededOnly) ? $this->LicenseReconciliationNeededOnly : null;
    }
    /**
     * Set LicenseReconciliationNeededOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $licenseReconciliationNeededOnly
     * @return \StructType\UserSearchDefinition
     */
    public function setLicenseReconciliationNeededOnly($licenseReconciliationNeededOnly = null)
    {
        if (is_null($licenseReconciliationNeededOnly) || (is_array($licenseReconciliationNeededOnly) && empty($licenseReconciliationNeededOnly))) {
            unset($this->LicenseReconciliationNeededOnly);
        } else {
            $this->LicenseReconciliationNeededOnly = $licenseReconciliationNeededOnly;
        }
        return $this;
    }
    /**
     * Get ReturnDeletedUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnDeletedUsers()
    {
        return isset($this->ReturnDeletedUsers) ? $this->ReturnDeletedUsers : null;
    }
    /**
     * Set ReturnDeletedUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnDeletedUsers
     * @return \StructType\UserSearchDefinition
     */
    public function setReturnDeletedUsers($returnDeletedUsers = null)
    {
        if (is_null($returnDeletedUsers) || (is_array($returnDeletedUsers) && empty($returnDeletedUsers))) {
            unset($this->ReturnDeletedUsers);
        } else {
            $this->ReturnDeletedUsers = $returnDeletedUsers;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\UserSearchDefinition
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Synchronized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSynchronized()
    {
        return isset($this->Synchronized) ? $this->Synchronized : null;
    }
    /**
     * Set Synchronized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $synchronized
     * @return \StructType\UserSearchDefinition
     */
    public function setSynchronized($synchronized = null)
    {
        if (is_null($synchronized) || (is_array($synchronized) && empty($synchronized))) {
            unset($this->Synchronized);
        } else {
            $this->Synchronized = $synchronized;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\UserSearchDefinition
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get UnlicensedUsersOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUnlicensedUsersOnly()
    {
        return isset($this->UnlicensedUsersOnly) ? $this->UnlicensedUsersOnly : null;
    }
    /**
     * Set UnlicensedUsersOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $unlicensedUsersOnly
     * @return \StructType\UserSearchDefinition
     */
    public function setUnlicensedUsersOnly($unlicensedUsersOnly = null)
    {
        if (is_null($unlicensedUsersOnly) || (is_array($unlicensedUsersOnly) && empty($unlicensedUsersOnly))) {
            unset($this->UnlicensedUsersOnly);
        } else {
            $this->UnlicensedUsersOnly = $unlicensedUsersOnly;
        }
        return $this;
    }
    /**
     * Get UsageLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsageLocation()
    {
        return isset($this->UsageLocation) ? $this->UsageLocation : null;
    }
    /**
     * Set UsageLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usageLocation
     * @return \StructType\UserSearchDefinition
     */
    public function setUsageLocation($usageLocation = null)
    {
        // validation for constraint: string
        if (!is_null($usageLocation) && !is_string($usageLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageLocation)), __LINE__);
        }
        if (is_null($usageLocation) || (is_array($usageLocation) && empty($usageLocation))) {
            unset($this->UsageLocation);
        } else {
            $this->UsageLocation = $usageLocation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserSearchDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
