<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceInstanceInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceInstanceInformation
 * @subpackage Structs
 */
class ServiceInstanceInformation extends AbstractStructBase
{
    /**
     * The GeographicLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GeographicLocation
     */
    public $GeographicLocation;
    /**
     * The ServiceInstance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceInstance;
    /**
     * The ServiceInstanceEndpoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceEndpoint
     */
    public $ServiceInstanceEndpoints;
    /**
     * Constructor method for ServiceInstanceInformation
     * @uses ServiceInstanceInformation::setGeographicLocation()
     * @uses ServiceInstanceInformation::setServiceInstance()
     * @uses ServiceInstanceInformation::setServiceInstanceEndpoints()
     * @param \StructType\GeographicLocation $geographicLocation
     * @param string $serviceInstance
     * @param \ArrayType\ArrayOfServiceEndpoint $serviceInstanceEndpoints
     */
    public function __construct(\StructType\GeographicLocation $geographicLocation = null, $serviceInstance = null, \ArrayType\ArrayOfServiceEndpoint $serviceInstanceEndpoints = null)
    {
        $this
            ->setGeographicLocation($geographicLocation)
            ->setServiceInstance($serviceInstance)
            ->setServiceInstanceEndpoints($serviceInstanceEndpoints);
    }
    /**
     * Get GeographicLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GeographicLocation|null
     */
    public function getGeographicLocation()
    {
        return isset($this->GeographicLocation) ? $this->GeographicLocation : null;
    }
    /**
     * Set GeographicLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GeographicLocation $geographicLocation
     * @return \StructType\ServiceInstanceInformation
     */
    public function setGeographicLocation(\StructType\GeographicLocation $geographicLocation = null)
    {
        if (is_null($geographicLocation) || (is_array($geographicLocation) && empty($geographicLocation))) {
            unset($this->GeographicLocation);
        } else {
            $this->GeographicLocation = $geographicLocation;
        }
        return $this;
    }
    /**
     * Get ServiceInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceInstance()
    {
        return isset($this->ServiceInstance) ? $this->ServiceInstance : null;
    }
    /**
     * Set ServiceInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceInstance
     * @return \StructType\ServiceInstanceInformation
     */
    public function setServiceInstance($serviceInstance = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInstance) && !is_string($serviceInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceInstance)), __LINE__);
        }
        if (is_null($serviceInstance) || (is_array($serviceInstance) && empty($serviceInstance))) {
            unset($this->ServiceInstance);
        } else {
            $this->ServiceInstance = $serviceInstance;
        }
        return $this;
    }
    /**
     * Get ServiceInstanceEndpoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServiceEndpoint|null
     */
    public function getServiceInstanceEndpoints()
    {
        return isset($this->ServiceInstanceEndpoints) ? $this->ServiceInstanceEndpoints : null;
    }
    /**
     * Set ServiceInstanceEndpoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServiceEndpoint $serviceInstanceEndpoints
     * @return \StructType\ServiceInstanceInformation
     */
    public function setServiceInstanceEndpoints(\ArrayType\ArrayOfServiceEndpoint $serviceInstanceEndpoints = null)
    {
        if (is_null($serviceInstanceEndpoints) || (is_array($serviceInstanceEndpoints) && empty($serviceInstanceEndpoints))) {
            unset($this->ServiceInstanceEndpoints);
        } else {
            $this->ServiceInstanceEndpoints = $serviceInstanceEndpoints;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceInstanceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
