<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchDefinition
 * @subpackage Structs
 */
class SearchDefinition extends AbstractStructBase
{
    /**
     * The PageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PageSize;
    /**
     * The SearchString
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchString;
    /**
     * The SortDirection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SortDirection;
    /**
     * The SortField
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SortField;
    /**
     * Constructor method for SearchDefinition
     * @uses SearchDefinition::setPageSize()
     * @uses SearchDefinition::setSearchString()
     * @uses SearchDefinition::setSortDirection()
     * @uses SearchDefinition::setSortField()
     * @param int $pageSize
     * @param string $searchString
     * @param string $sortDirection
     * @param string $sortField
     */
    public function __construct($pageSize = null, $searchString = null, $sortDirection = null, $sortField = null)
    {
        $this
            ->setPageSize($pageSize)
            ->setSearchString($searchString)
            ->setSortDirection($sortDirection)
            ->setSortField($sortField);
    }
    /**
     * Get PageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \StructType\SearchDefinition
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !is_numeric($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get SearchString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchString()
    {
        return isset($this->SearchString) ? $this->SearchString : null;
    }
    /**
     * Set SearchString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchString
     * @return \StructType\SearchDefinition
     */
    public function setSearchString($searchString = null)
    {
        // validation for constraint: string
        if (!is_null($searchString) && !is_string($searchString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchString)), __LINE__);
        }
        if (is_null($searchString) || (is_array($searchString) && empty($searchString))) {
            unset($this->SearchString);
        } else {
            $this->SearchString = $searchString;
        }
        return $this;
    }
    /**
     * Get SortDirection value
     * @return string|null
     */
    public function getSortDirection()
    {
        return $this->SortDirection;
    }
    /**
     * Set SortDirection value
     * @uses \EnumType\SortDirection::valueIsValid()
     * @uses \EnumType\SortDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortDirection
     * @return \StructType\SearchDefinition
     */
    public function setSortDirection($sortDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortDirection::valueIsValid($sortDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortDirection, implode(', ', \EnumType\SortDirection::getValidValues())), __LINE__);
        }
        $this->SortDirection = $sortDirection;
        return $this;
    }
    /**
     * Get SortField value
     * @return string|null
     */
    public function getSortField()
    {
        return $this->SortField;
    }
    /**
     * Set SortField value
     * @uses \EnumType\SortField::valueIsValid()
     * @uses \EnumType\SortField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortField
     * @return \StructType\SearchDefinition
     */
    public function setSortField($sortField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortField::valueIsValid($sortField)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortField, implode(', ', \EnumType\SortField::getValidValues())), __LINE__);
        }
        $this->SortField = $sortField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
