<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoleScopedMemberSearchDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoleScopedMemberSearchDefinition
 * @subpackage Structs
 */
class RoleScopedMemberSearchDefinition extends RoleMemberSearchDefinition
{
    /**
     * The AdministrativeUnitObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdministrativeUnitObjectId;
    /**
     * Constructor method for RoleScopedMemberSearchDefinition
     * @uses RoleScopedMemberSearchDefinition::setAdministrativeUnitObjectId()
     * @param string $administrativeUnitObjectId
     */
    public function __construct($administrativeUnitObjectId = null)
    {
        $this
            ->setAdministrativeUnitObjectId($administrativeUnitObjectId);
    }
    /**
     * Get AdministrativeUnitObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdministrativeUnitObjectId()
    {
        return isset($this->AdministrativeUnitObjectId) ? $this->AdministrativeUnitObjectId : null;
    }
    /**
     * Set AdministrativeUnitObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $administrativeUnitObjectId
     * @return \StructType\RoleScopedMemberSearchDefinition
     */
    public function setAdministrativeUnitObjectId($administrativeUnitObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($administrativeUnitObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($administrativeUnitObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($administrativeUnitObjectId) && !is_string($administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($administrativeUnitObjectId)), __LINE__);
        }
        if (is_null($administrativeUnitObjectId) || (is_array($administrativeUnitObjectId) && empty($administrativeUnitObjectId))) {
            unset($this->AdministrativeUnitObjectId);
        } else {
            $this->AdministrativeUnitObjectId = $administrativeUnitObjectId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoleScopedMemberSearchDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
