<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestoreUserError StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RestoreUserError
 * @subpackage Structs
 */
class RestoreUserError extends AbstractStructBase
{
    /**
     * The ConflictingObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ConflictingObjectId;
    /**
     * The CurrentValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentValue;
    /**
     * The ErrorId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorId;
    /**
     * The ErrorType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorType;
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ObjectType;
    /**
     * The SuggestedValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SuggestedValue;
    /**
     * Constructor method for RestoreUserError
     * @uses RestoreUserError::setConflictingObjectId()
     * @uses RestoreUserError::setCurrentValue()
     * @uses RestoreUserError::setErrorId()
     * @uses RestoreUserError::setErrorType()
     * @uses RestoreUserError::setObjectType()
     * @uses RestoreUserError::setSuggestedValue()
     * @param string $conflictingObjectId
     * @param string $currentValue
     * @param string $errorId
     * @param string $errorType
     * @param string $objectType
     * @param string $suggestedValue
     */
    public function __construct($conflictingObjectId = null, $currentValue = null, $errorId = null, $errorType = null, $objectType = null, $suggestedValue = null)
    {
        $this
            ->setConflictingObjectId($conflictingObjectId)
            ->setCurrentValue($currentValue)
            ->setErrorId($errorId)
            ->setErrorType($errorType)
            ->setObjectType($objectType)
            ->setSuggestedValue($suggestedValue);
    }
    /**
     * Get ConflictingObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConflictingObjectId()
    {
        return isset($this->ConflictingObjectId) ? $this->ConflictingObjectId : null;
    }
    /**
     * Set ConflictingObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conflictingObjectId
     * @return \StructType\RestoreUserError
     */
    public function setConflictingObjectId($conflictingObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($conflictingObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $conflictingObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($conflictingObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($conflictingObjectId) && !is_string($conflictingObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conflictingObjectId)), __LINE__);
        }
        if (is_null($conflictingObjectId) || (is_array($conflictingObjectId) && empty($conflictingObjectId))) {
            unset($this->ConflictingObjectId);
        } else {
            $this->ConflictingObjectId = $conflictingObjectId;
        }
        return $this;
    }
    /**
     * Get CurrentValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentValue()
    {
        return isset($this->CurrentValue) ? $this->CurrentValue : null;
    }
    /**
     * Set CurrentValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentValue
     * @return \StructType\RestoreUserError
     */
    public function setCurrentValue($currentValue = null)
    {
        // validation for constraint: string
        if (!is_null($currentValue) && !is_string($currentValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentValue)), __LINE__);
        }
        if (is_null($currentValue) || (is_array($currentValue) && empty($currentValue))) {
            unset($this->CurrentValue);
        } else {
            $this->CurrentValue = $currentValue;
        }
        return $this;
    }
    /**
     * Get ErrorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorId()
    {
        return isset($this->ErrorId) ? $this->ErrorId : null;
    }
    /**
     * Set ErrorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorId
     * @return \StructType\RestoreUserError
     */
    public function setErrorId($errorId = null)
    {
        // validation for constraint: string
        if (!is_null($errorId) && !is_string($errorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorId)), __LINE__);
        }
        if (is_null($errorId) || (is_array($errorId) && empty($errorId))) {
            unset($this->ErrorId);
        } else {
            $this->ErrorId = $errorId;
        }
        return $this;
    }
    /**
     * Get ErrorType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorType()
    {
        return isset($this->ErrorType) ? $this->ErrorType : null;
    }
    /**
     * Set ErrorType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorType
     * @return \StructType\RestoreUserError
     */
    public function setErrorType($errorType = null)
    {
        // validation for constraint: string
        if (!is_null($errorType) && !is_string($errorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorType)), __LINE__);
        }
        if (is_null($errorType) || (is_array($errorType) && empty($errorType))) {
            unset($this->ErrorType);
        } else {
            $this->ErrorType = $errorType;
        }
        return $this;
    }
    /**
     * Get ObjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectType()
    {
        return isset($this->ObjectType) ? $this->ObjectType : null;
    }
    /**
     * Set ObjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectType
     * @return \StructType\RestoreUserError
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectType)), __LINE__);
        }
        if (is_null($objectType) || (is_array($objectType) && empty($objectType))) {
            unset($this->ObjectType);
        } else {
            $this->ObjectType = $objectType;
        }
        return $this;
    }
    /**
     * Get SuggestedValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuggestedValue()
    {
        return isset($this->SuggestedValue) ? $this->SuggestedValue : null;
    }
    /**
     * Set SuggestedValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suggestedValue
     * @return \StructType\RestoreUserError
     */
    public function setSuggestedValue($suggestedValue = null)
    {
        // validation for constraint: string
        if (!is_null($suggestedValue) && !is_string($suggestedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suggestedValue)), __LINE__);
        }
        if (is_null($suggestedValue) || (is_array($suggestedValue) && empty($suggestedValue))) {
            unset($this->SuggestedValue);
        } else {
            $this->SuggestedValue = $suggestedValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestoreUserError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
