<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerRoleMapEntry StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PartnerRoleMapEntry
 * @subpackage Structs
 */
class PartnerRoleMapEntry extends AbstractStructBase
{
    /**
     * The RoleId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleId;
    /**
     * Constructor method for PartnerRoleMapEntry
     * @uses PartnerRoleMapEntry::setRoleId()
     * @param string $roleId
     */
    public function __construct($roleId = null)
    {
        $this
            ->setRoleId($roleId);
    }
    /**
     * Get RoleId value
     * @return string|null
     */
    public function getRoleId()
    {
        return $this->RoleId;
    }
    /**
     * Set RoleId value
     * @param string $roleId
     * @return \StructType\PartnerRoleMapEntry
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($roleId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($roleId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roleId) && !is_string($roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleId)), __LINE__);
        }
        $this->RoleId = $roleId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerRoleMapEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
