<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerContractSearchDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PartnerContractSearchDefinition
 * @subpackage Structs
 */
class PartnerContractSearchDefinition extends SearchDefinition
{
    /**
     * The ContractType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractType;
    /**
     * The DomainName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainName;
    /**
     * The ManagedTenantId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ManagedTenantId;
    /**
     * The SearchKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchKey;
    /**
     * Constructor method for PartnerContractSearchDefinition
     * @uses PartnerContractSearchDefinition::setContractType()
     * @uses PartnerContractSearchDefinition::setDomainName()
     * @uses PartnerContractSearchDefinition::setManagedTenantId()
     * @uses PartnerContractSearchDefinition::setSearchKey()
     * @param string $contractType
     * @param string $domainName
     * @param string $managedTenantId
     * @param string $searchKey
     */
    public function __construct($contractType = null, $domainName = null, $managedTenantId = null, $searchKey = null)
    {
        $this
            ->setContractType($contractType)
            ->setDomainName($domainName)
            ->setManagedTenantId($managedTenantId)
            ->setSearchKey($searchKey);
    }
    /**
     * Get ContractType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractType()
    {
        return isset($this->ContractType) ? $this->ContractType : null;
    }
    /**
     * Set ContractType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ContractType::valueIsValid()
     * @uses \EnumType\ContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contractType
     * @return \StructType\PartnerContractSearchDefinition
     */
    public function setContractType($contractType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContractType::valueIsValid($contractType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contractType, implode(', ', \EnumType\ContractType::getValidValues())), __LINE__);
        }
        if (is_null($contractType) || (is_array($contractType) && empty($contractType))) {
            unset($this->ContractType);
        } else {
            $this->ContractType = $contractType;
        }
        return $this;
    }
    /**
     * Get DomainName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->DomainName) ? $this->DomainName : null;
    }
    /**
     * Set DomainName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainName
     * @return \StructType\PartnerContractSearchDefinition
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->DomainName);
        } else {
            $this->DomainName = $domainName;
        }
        return $this;
    }
    /**
     * Get ManagedTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManagedTenantId()
    {
        return isset($this->ManagedTenantId) ? $this->ManagedTenantId : null;
    }
    /**
     * Set ManagedTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $managedTenantId
     * @return \StructType\PartnerContractSearchDefinition
     */
    public function setManagedTenantId($managedTenantId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($managedTenantId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $managedTenantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($managedTenantId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($managedTenantId) && !is_string($managedTenantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($managedTenantId)), __LINE__);
        }
        if (is_null($managedTenantId) || (is_array($managedTenantId) && empty($managedTenantId))) {
            unset($this->ManagedTenantId);
        } else {
            $this->ManagedTenantId = $managedTenantId;
        }
        return $this;
    }
    /**
     * Get SearchKey value
     * @return string|null
     */
    public function getSearchKey()
    {
        return $this->SearchKey;
    }
    /**
     * Set SearchKey value
     * @uses \EnumType\PartnerContractSearchKey::valueIsValid()
     * @uses \EnumType\PartnerContractSearchKey::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchKey
     * @return \StructType\PartnerContractSearchDefinition
     */
    public function setSearchKey($searchKey = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PartnerContractSearchKey::valueIsValid($searchKey)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchKey, implode(', ', \EnumType\PartnerContractSearchKey::getValidValues())), __LINE__);
        }
        $this->SearchKey = $searchKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerContractSearchDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
