<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectWithDirSyncErrors StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ObjectWithDirSyncErrors
 * @subpackage Structs
 */
class ObjectWithDirSyncErrors extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The ImmutableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImmutableId;
    /**
     * The LastDirSyncTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDirSyncTime;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ObjectType;
    /**
     * The ProvisioningErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDirSyncProvisioningError
     */
    public $ProvisioningErrors;
    /**
     * The ProxyAddresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ProxyAddresses;
    /**
     * The UserPrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPrincipalName;
    /**
     * Constructor method for ObjectWithDirSyncErrors
     * @uses ObjectWithDirSyncErrors::setDisplayName()
     * @uses ObjectWithDirSyncErrors::setImmutableId()
     * @uses ObjectWithDirSyncErrors::setLastDirSyncTime()
     * @uses ObjectWithDirSyncErrors::setObjectId()
     * @uses ObjectWithDirSyncErrors::setObjectType()
     * @uses ObjectWithDirSyncErrors::setProvisioningErrors()
     * @uses ObjectWithDirSyncErrors::setProxyAddresses()
     * @uses ObjectWithDirSyncErrors::setUserPrincipalName()
     * @param string $displayName
     * @param string $immutableId
     * @param string $lastDirSyncTime
     * @param string $objectId
     * @param string $objectType
     * @param \ArrayType\ArrayOfDirSyncProvisioningError $provisioningErrors
     * @param \ArrayType\ArrayOfstring $proxyAddresses
     * @param string $userPrincipalName
     */
    public function __construct($displayName = null, $immutableId = null, $lastDirSyncTime = null, $objectId = null, $objectType = null, \ArrayType\ArrayOfDirSyncProvisioningError $provisioningErrors = null, \ArrayType\ArrayOfstring $proxyAddresses = null, $userPrincipalName = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setImmutableId($immutableId)
            ->setLastDirSyncTime($lastDirSyncTime)
            ->setObjectId($objectId)
            ->setObjectType($objectType)
            ->setProvisioningErrors($provisioningErrors)
            ->setProxyAddresses($proxyAddresses)
            ->setUserPrincipalName($userPrincipalName);
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get ImmutableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImmutableId()
    {
        return isset($this->ImmutableId) ? $this->ImmutableId : null;
    }
    /**
     * Set ImmutableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $immutableId
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public function setImmutableId($immutableId = null)
    {
        // validation for constraint: string
        if (!is_null($immutableId) && !is_string($immutableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($immutableId)), __LINE__);
        }
        if (is_null($immutableId) || (is_array($immutableId) && empty($immutableId))) {
            unset($this->ImmutableId);
        } else {
            $this->ImmutableId = $immutableId;
        }
        return $this;
    }
    /**
     * Get LastDirSyncTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDirSyncTime()
    {
        return isset($this->LastDirSyncTime) ? $this->LastDirSyncTime : null;
    }
    /**
     * Set LastDirSyncTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDirSyncTime
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public function setLastDirSyncTime($lastDirSyncTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDirSyncTime) && !is_string($lastDirSyncTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDirSyncTime)), __LINE__);
        }
        if (is_null($lastDirSyncTime) || (is_array($lastDirSyncTime) && empty($lastDirSyncTime))) {
            unset($this->LastDirSyncTime);
        } else {
            $this->LastDirSyncTime = $lastDirSyncTime;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get ObjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectType()
    {
        return isset($this->ObjectType) ? $this->ObjectType : null;
    }
    /**
     * Set ObjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectType
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectType)), __LINE__);
        }
        if (is_null($objectType) || (is_array($objectType) && empty($objectType))) {
            unset($this->ObjectType);
        } else {
            $this->ObjectType = $objectType;
        }
        return $this;
    }
    /**
     * Get ProvisioningErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDirSyncProvisioningError|null
     */
    public function getProvisioningErrors()
    {
        return isset($this->ProvisioningErrors) ? $this->ProvisioningErrors : null;
    }
    /**
     * Set ProvisioningErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDirSyncProvisioningError $provisioningErrors
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public function setProvisioningErrors(\ArrayType\ArrayOfDirSyncProvisioningError $provisioningErrors = null)
    {
        if (is_null($provisioningErrors) || (is_array($provisioningErrors) && empty($provisioningErrors))) {
            unset($this->ProvisioningErrors);
        } else {
            $this->ProvisioningErrors = $provisioningErrors;
        }
        return $this;
    }
    /**
     * Get ProxyAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getProxyAddresses()
    {
        return isset($this->ProxyAddresses) ? $this->ProxyAddresses : null;
    }
    /**
     * Set ProxyAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $proxyAddresses
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public function setProxyAddresses(\ArrayType\ArrayOfstring $proxyAddresses = null)
    {
        if (is_null($proxyAddresses) || (is_array($proxyAddresses) && empty($proxyAddresses))) {
            unset($this->ProxyAddresses);
        } else {
            $this->ProxyAddresses = $proxyAddresses;
        }
        return $this;
    }
    /**
     * Get UserPrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPrincipalName()
    {
        return isset($this->UserPrincipalName) ? $this->UserPrincipalName : null;
    }
    /**
     * Set UserPrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPrincipalName
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public function setUserPrincipalName($userPrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($userPrincipalName) && !is_string($userPrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPrincipalName)), __LINE__);
        }
        if (is_null($userPrincipalName) || (is_array($userPrincipalName) && empty($userPrincipalName))) {
            unset($this->UserPrincipalName);
        } else {
            $this->UserPrincipalName = $userPrincipalName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ObjectWithDirSyncErrors
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
