<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndirectLicenseFilter StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:IndirectLicenseFilter
 * @subpackage Structs
 */
class IndirectLicenseFilter extends AbstractStructBase
{
    /**
     * The HasErrorsOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasErrorsOnly;
    /**
     * The ReferenceObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferenceObjectId;
    /**
     * Constructor method for IndirectLicenseFilter
     * @uses IndirectLicenseFilter::setHasErrorsOnly()
     * @uses IndirectLicenseFilter::setReferenceObjectId()
     * @param bool $hasErrorsOnly
     * @param string $referenceObjectId
     */
    public function __construct($hasErrorsOnly = null, $referenceObjectId = null)
    {
        $this
            ->setHasErrorsOnly($hasErrorsOnly)
            ->setReferenceObjectId($referenceObjectId);
    }
    /**
     * Get HasErrorsOnly value
     * @return bool|null
     */
    public function getHasErrorsOnly()
    {
        return $this->HasErrorsOnly;
    }
    /**
     * Set HasErrorsOnly value
     * @param bool $hasErrorsOnly
     * @return \StructType\IndirectLicenseFilter
     */
    public function setHasErrorsOnly($hasErrorsOnly = null)
    {
        $this->HasErrorsOnly = $hasErrorsOnly;
        return $this;
    }
    /**
     * Get ReferenceObjectId value
     * @return string|null
     */
    public function getReferenceObjectId()
    {
        return $this->ReferenceObjectId;
    }
    /**
     * Set ReferenceObjectId value
     * @param string $referenceObjectId
     * @return \StructType\IndirectLicenseFilter
     */
    public function setReferenceObjectId($referenceObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($referenceObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $referenceObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($referenceObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenceObjectId) && !is_string($referenceObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceObjectId)), __LINE__);
        }
        $this->ReferenceObjectId = $referenceObjectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IndirectLicenseFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
