<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupLicenseProcessingDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupLicenseProcessingDetail
 * @subpackage Structs
 */
class GroupLicenseProcessingDetail extends AbstractStructBase
{
    /**
     * The Operation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for GroupLicenseProcessingDetail
     * @uses GroupLicenseProcessingDetail::setOperation()
     * @uses GroupLicenseProcessingDetail::setStatus()
     * @param string $operation
     * @param string $status
     */
    public function __construct($operation = null, $status = null)
    {
        $this
            ->setOperation($operation)
            ->setStatus($status);
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operation
     * @return \StructType\GroupLicenseProcessingDetail
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operation)), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\GroupLicenseProcessingStatus::valueIsValid()
     * @uses \EnumType\GroupLicenseProcessingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\GroupLicenseProcessingDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupLicenseProcessingStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\GroupLicenseProcessingStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupLicenseProcessingDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
