<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServiceStatusResponse StructType
 * @subpackage Structs
 */
class GetServiceStatusResponse extends AbstractStructBase
{
    /**
     * The GetServiceStatusResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GetServiceStatusResult;
    /**
     * Constructor method for GetServiceStatusResponse
     * @uses GetServiceStatusResponse::setGetServiceStatusResult()
     * @param string $getServiceStatusResult
     */
    public function __construct($getServiceStatusResult = null)
    {
        $this
            ->setGetServiceStatusResult($getServiceStatusResult);
    }
    /**
     * Get GetServiceStatusResult value
     * @return string
     */
    public function getGetServiceStatusResult()
    {
        return $this->GetServiceStatusResult;
    }
    /**
     * Set GetServiceStatusResult value
     * @uses \EnumType\HttpStatusCode::valueIsValid()
     * @uses \EnumType\HttpStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $getServiceStatusResult
     * @return \StructType\GetServiceStatusResponse
     */
    public function setGetServiceStatusResult($getServiceStatusResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HttpStatusCode::valueIsValid($getServiceStatusResult)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $getServiceStatusResult, implode(', ', \EnumType\HttpStatusCode::getValidValues())), __LINE__);
        }
        $this->GetServiceStatusResult = $getServiceStatusResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetServiceStatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
