<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainVerificationResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainVerificationResult
 * @subpackage Structs
 */
class DomainVerificationResult extends AbstractStructBase
{
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Availability;
    /**
     * The EmailVerifiedInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmailVerifiedDomainInformation
     */
    public $EmailVerifiedInformation;
    /**
     * Constructor method for DomainVerificationResult
     * @uses DomainVerificationResult::setAvailability()
     * @uses DomainVerificationResult::setEmailVerifiedInformation()
     * @param string $availability
     * @param \StructType\EmailVerifiedDomainInformation $emailVerifiedInformation
     */
    public function __construct($availability = null, \StructType\EmailVerifiedDomainInformation $emailVerifiedInformation = null)
    {
        $this
            ->setAvailability($availability)
            ->setEmailVerifiedInformation($emailVerifiedInformation);
    }
    /**
     * Get Availability value
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @uses \EnumType\DomainAvailability::valueIsValid()
     * @uses \EnumType\DomainAvailability::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availability
     * @return \StructType\DomainVerificationResult
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainAvailability::valueIsValid($availability)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availability, implode(', ', \EnumType\DomainAvailability::getValidValues())), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get EmailVerifiedInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmailVerifiedDomainInformation|null
     */
    public function getEmailVerifiedInformation()
    {
        return isset($this->EmailVerifiedInformation) ? $this->EmailVerifiedInformation : null;
    }
    /**
     * Set EmailVerifiedInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EmailVerifiedDomainInformation $emailVerifiedInformation
     * @return \StructType\DomainVerificationResult
     */
    public function setEmailVerifiedInformation(\StructType\EmailVerifiedDomainInformation $emailVerifiedInformation = null)
    {
        if (is_null($emailVerifiedInformation) || (is_array($emailVerifiedInformation) && empty($emailVerifiedInformation))) {
            unset($this->EmailVerifiedInformation);
        } else {
            $this->EmailVerifiedInformation = $emailVerifiedInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainVerificationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
