<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainDnsMXRecord StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainDnsMXRecord
 * @subpackage Structs
 */
class DomainDnsMXRecord extends DomainDnsRecord
{
    /**
     * The MailExchange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailExchange;
    /**
     * The Preference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Preference;
    /**
     * Constructor method for DomainDnsMXRecord
     * @uses DomainDnsMXRecord::setMailExchange()
     * @uses DomainDnsMXRecord::setPreference()
     * @param string $mailExchange
     * @param int $preference
     */
    public function __construct($mailExchange = null, $preference = null)
    {
        $this
            ->setMailExchange($mailExchange)
            ->setPreference($preference);
    }
    /**
     * Get MailExchange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailExchange()
    {
        return isset($this->MailExchange) ? $this->MailExchange : null;
    }
    /**
     * Set MailExchange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailExchange
     * @return \StructType\DomainDnsMXRecord
     */
    public function setMailExchange($mailExchange = null)
    {
        // validation for constraint: string
        if (!is_null($mailExchange) && !is_string($mailExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailExchange)), __LINE__);
        }
        if (is_null($mailExchange) || (is_array($mailExchange) && empty($mailExchange))) {
            unset($this->MailExchange);
        } else {
            $this->MailExchange = $mailExchange;
        }
        return $this;
    }
    /**
     * Get Preference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPreference()
    {
        return isset($this->Preference) ? $this->Preference : null;
    }
    /**
     * Set Preference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $preference
     * @return \StructType\DomainDnsMXRecord
     */
    public function setPreference($preference = null)
    {
        // validation for constraint: int
        if (!is_null($preference) && !is_numeric($preference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($preference)), __LINE__);
        }
        if (is_null($preference) || (is_array($preference) && empty($preference))) {
            unset($this->Preference);
        } else {
            $this->Preference = $preference;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainDnsMXRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
