<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddForeignGroupToRoleRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddForeignGroupToRoleRequest
 * @subpackage Structs
 */
class AddForeignGroupToRoleRequest extends Request
{
    /**
     * The ForeignCompanyObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForeignCompanyObjectId;
    /**
     * The ForeignGroupObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForeignGroupObjectId;
    /**
     * The RoleObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleObjectId;
    /**
     * Constructor method for AddForeignGroupToRoleRequest
     * @uses AddForeignGroupToRoleRequest::setForeignCompanyObjectId()
     * @uses AddForeignGroupToRoleRequest::setForeignGroupObjectId()
     * @uses AddForeignGroupToRoleRequest::setRoleObjectId()
     * @param string $foreignCompanyObjectId
     * @param string $foreignGroupObjectId
     * @param string $roleObjectId
     */
    public function __construct($foreignCompanyObjectId = null, $foreignGroupObjectId = null, $roleObjectId = null)
    {
        $this
            ->setForeignCompanyObjectId($foreignCompanyObjectId)
            ->setForeignGroupObjectId($foreignGroupObjectId)
            ->setRoleObjectId($roleObjectId);
    }
    /**
     * Get ForeignCompanyObjectId value
     * @return string|null
     */
    public function getForeignCompanyObjectId()
    {
        return $this->ForeignCompanyObjectId;
    }
    /**
     * Set ForeignCompanyObjectId value
     * @param string $foreignCompanyObjectId
     * @return \StructType\AddForeignGroupToRoleRequest
     */
    public function setForeignCompanyObjectId($foreignCompanyObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($foreignCompanyObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $foreignCompanyObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($foreignCompanyObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($foreignCompanyObjectId) && !is_string($foreignCompanyObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foreignCompanyObjectId)), __LINE__);
        }
        $this->ForeignCompanyObjectId = $foreignCompanyObjectId;
        return $this;
    }
    /**
     * Get ForeignGroupObjectId value
     * @return string|null
     */
    public function getForeignGroupObjectId()
    {
        return $this->ForeignGroupObjectId;
    }
    /**
     * Set ForeignGroupObjectId value
     * @param string $foreignGroupObjectId
     * @return \StructType\AddForeignGroupToRoleRequest
     */
    public function setForeignGroupObjectId($foreignGroupObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($foreignGroupObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $foreignGroupObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($foreignGroupObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($foreignGroupObjectId) && !is_string($foreignGroupObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foreignGroupObjectId)), __LINE__);
        }
        $this->ForeignGroupObjectId = $foreignGroupObjectId;
        return $this;
    }
    /**
     * Get RoleObjectId value
     * @return string|null
     */
    public function getRoleObjectId()
    {
        return $this->RoleObjectId;
    }
    /**
     * Set RoleObjectId value
     * @param string $roleObjectId
     * @return \StructType\AddForeignGroupToRoleRequest
     */
    public function setRoleObjectId($roleObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($roleObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $roleObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($roleObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roleObjectId) && !is_string($roleObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleObjectId)), __LINE__);
        }
        $this->RoleObjectId = $roleObjectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddForeignGroupToRoleRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
