<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSkuDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountSkuDetails
 * @subpackage Structs
 */
class AccountSkuDetails extends AbstractStructBase
{
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountObjectId;
    /**
     * The AccountSkuId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountSkuId;
    /**
     * The ActiveUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ActiveUnits;
    /**
     * The ConsumedUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ConsumedUnits;
    /**
     * The LockedOutUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LockedOutUnits;
    /**
     * The ServiceStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceStatus
     */
    public $ServiceStatus;
    /**
     * The SkuId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SkuId;
    /**
     * The SkuPartNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SkuPartNumber;
    /**
     * The SubscriptionIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfguid
     */
    public $SubscriptionIds;
    /**
     * The SuspendedUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SuspendedUnits;
    /**
     * The TargetClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TargetClass;
    /**
     * The WarningUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WarningUnits;
    /**
     * Constructor method for AccountSkuDetails
     * @uses AccountSkuDetails::setAccountName()
     * @uses AccountSkuDetails::setAccountObjectId()
     * @uses AccountSkuDetails::setAccountSkuId()
     * @uses AccountSkuDetails::setActiveUnits()
     * @uses AccountSkuDetails::setConsumedUnits()
     * @uses AccountSkuDetails::setLockedOutUnits()
     * @uses AccountSkuDetails::setServiceStatus()
     * @uses AccountSkuDetails::setSkuId()
     * @uses AccountSkuDetails::setSkuPartNumber()
     * @uses AccountSkuDetails::setSubscriptionIds()
     * @uses AccountSkuDetails::setSuspendedUnits()
     * @uses AccountSkuDetails::setTargetClass()
     * @uses AccountSkuDetails::setWarningUnits()
     * @param string $accountName
     * @param string $accountObjectId
     * @param string $accountSkuId
     * @param int $activeUnits
     * @param int $consumedUnits
     * @param int $lockedOutUnits
     * @param \ArrayType\ArrayOfServiceStatus $serviceStatus
     * @param string $skuId
     * @param string $skuPartNumber
     * @param \ArrayType\ArrayOfguid $subscriptionIds
     * @param int $suspendedUnits
     * @param string $targetClass
     * @param int $warningUnits
     */
    public function __construct($accountName = null, $accountObjectId = null, $accountSkuId = null, $activeUnits = null, $consumedUnits = null, $lockedOutUnits = null, \ArrayType\ArrayOfServiceStatus $serviceStatus = null, $skuId = null, $skuPartNumber = null, \ArrayType\ArrayOfguid $subscriptionIds = null, $suspendedUnits = null, $targetClass = null, $warningUnits = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAccountObjectId($accountObjectId)
            ->setAccountSkuId($accountSkuId)
            ->setActiveUnits($activeUnits)
            ->setConsumedUnits($consumedUnits)
            ->setLockedOutUnits($lockedOutUnits)
            ->setServiceStatus($serviceStatus)
            ->setSkuId($skuId)
            ->setSkuPartNumber($skuPartNumber)
            ->setSubscriptionIds($subscriptionIds)
            ->setSuspendedUnits($suspendedUnits)
            ->setTargetClass($targetClass)
            ->setWarningUnits($warningUnits);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \StructType\AccountSkuDetails
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountObjectId value
     * @return string|null
     */
    public function getAccountObjectId()
    {
        return $this->AccountObjectId;
    }
    /**
     * Set AccountObjectId value
     * @param string $accountObjectId
     * @return \StructType\AccountSkuDetails
     */
    public function setAccountObjectId($accountObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($accountObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $accountObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($accountObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountObjectId) && !is_string($accountObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountObjectId)), __LINE__);
        }
        $this->AccountObjectId = $accountObjectId;
        return $this;
    }
    /**
     * Get AccountSkuId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountSkuId()
    {
        return isset($this->AccountSkuId) ? $this->AccountSkuId : null;
    }
    /**
     * Set AccountSkuId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountSkuId
     * @return \StructType\AccountSkuDetails
     */
    public function setAccountSkuId($accountSkuId = null)
    {
        // validation for constraint: string
        if (!is_null($accountSkuId) && !is_string($accountSkuId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountSkuId)), __LINE__);
        }
        if (is_null($accountSkuId) || (is_array($accountSkuId) && empty($accountSkuId))) {
            unset($this->AccountSkuId);
        } else {
            $this->AccountSkuId = $accountSkuId;
        }
        return $this;
    }
    /**
     * Get ActiveUnits value
     * @return int|null
     */
    public function getActiveUnits()
    {
        return $this->ActiveUnits;
    }
    /**
     * Set ActiveUnits value
     * @param int $activeUnits
     * @return \StructType\AccountSkuDetails
     */
    public function setActiveUnits($activeUnits = null)
    {
        // validation for constraint: int
        if (!is_null($activeUnits) && !is_numeric($activeUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activeUnits)), __LINE__);
        }
        $this->ActiveUnits = $activeUnits;
        return $this;
    }
    /**
     * Get ConsumedUnits value
     * @return int|null
     */
    public function getConsumedUnits()
    {
        return $this->ConsumedUnits;
    }
    /**
     * Set ConsumedUnits value
     * @param int $consumedUnits
     * @return \StructType\AccountSkuDetails
     */
    public function setConsumedUnits($consumedUnits = null)
    {
        // validation for constraint: int
        if (!is_null($consumedUnits) && !is_numeric($consumedUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($consumedUnits)), __LINE__);
        }
        $this->ConsumedUnits = $consumedUnits;
        return $this;
    }
    /**
     * Get LockedOutUnits value
     * @return int|null
     */
    public function getLockedOutUnits()
    {
        return $this->LockedOutUnits;
    }
    /**
     * Set LockedOutUnits value
     * @param int $lockedOutUnits
     * @return \StructType\AccountSkuDetails
     */
    public function setLockedOutUnits($lockedOutUnits = null)
    {
        // validation for constraint: int
        if (!is_null($lockedOutUnits) && !is_numeric($lockedOutUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lockedOutUnits)), __LINE__);
        }
        $this->LockedOutUnits = $lockedOutUnits;
        return $this;
    }
    /**
     * Get ServiceStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServiceStatus|null
     */
    public function getServiceStatus()
    {
        return isset($this->ServiceStatus) ? $this->ServiceStatus : null;
    }
    /**
     * Set ServiceStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServiceStatus $serviceStatus
     * @return \StructType\AccountSkuDetails
     */
    public function setServiceStatus(\ArrayType\ArrayOfServiceStatus $serviceStatus = null)
    {
        if (is_null($serviceStatus) || (is_array($serviceStatus) && empty($serviceStatus))) {
            unset($this->ServiceStatus);
        } else {
            $this->ServiceStatus = $serviceStatus;
        }
        return $this;
    }
    /**
     * Get SkuId value
     * @return string|null
     */
    public function getSkuId()
    {
        return $this->SkuId;
    }
    /**
     * Set SkuId value
     * @param string $skuId
     * @return \StructType\AccountSkuDetails
     */
    public function setSkuId($skuId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($skuId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $skuId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($skuId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($skuId) && !is_string($skuId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skuId)), __LINE__);
        }
        $this->SkuId = $skuId;
        return $this;
    }
    /**
     * Get SkuPartNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSkuPartNumber()
    {
        return isset($this->SkuPartNumber) ? $this->SkuPartNumber : null;
    }
    /**
     * Set SkuPartNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $skuPartNumber
     * @return \StructType\AccountSkuDetails
     */
    public function setSkuPartNumber($skuPartNumber = null)
    {
        // validation for constraint: string
        if (!is_null($skuPartNumber) && !is_string($skuPartNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skuPartNumber)), __LINE__);
        }
        if (is_null($skuPartNumber) || (is_array($skuPartNumber) && empty($skuPartNumber))) {
            unset($this->SkuPartNumber);
        } else {
            $this->SkuPartNumber = $skuPartNumber;
        }
        return $this;
    }
    /**
     * Get SubscriptionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfguid|null
     */
    public function getSubscriptionIds()
    {
        return isset($this->SubscriptionIds) ? $this->SubscriptionIds : null;
    }
    /**
     * Set SubscriptionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfguid $subscriptionIds
     * @return \StructType\AccountSkuDetails
     */
    public function setSubscriptionIds(\ArrayType\ArrayOfguid $subscriptionIds = null)
    {
        if (is_null($subscriptionIds) || (is_array($subscriptionIds) && empty($subscriptionIds))) {
            unset($this->SubscriptionIds);
        } else {
            $this->SubscriptionIds = $subscriptionIds;
        }
        return $this;
    }
    /**
     * Get SuspendedUnits value
     * @return int|null
     */
    public function getSuspendedUnits()
    {
        return $this->SuspendedUnits;
    }
    /**
     * Set SuspendedUnits value
     * @param int $suspendedUnits
     * @return \StructType\AccountSkuDetails
     */
    public function setSuspendedUnits($suspendedUnits = null)
    {
        // validation for constraint: int
        if (!is_null($suspendedUnits) && !is_numeric($suspendedUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suspendedUnits)), __LINE__);
        }
        $this->SuspendedUnits = $suspendedUnits;
        return $this;
    }
    /**
     * Get TargetClass value
     * @return string|null
     */
    public function getTargetClass()
    {
        return $this->TargetClass;
    }
    /**
     * Set TargetClass value
     * @uses \EnumType\SkuTargetClass::valueIsValid()
     * @uses \EnumType\SkuTargetClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetClass
     * @return \StructType\AccountSkuDetails
     */
    public function setTargetClass($targetClass = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SkuTargetClass::valueIsValid($targetClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $targetClass, implode(', ', \EnumType\SkuTargetClass::getValidValues())), __LINE__);
        }
        $this->TargetClass = $targetClass;
        return $this;
    }
    /**
     * Get WarningUnits value
     * @return int|null
     */
    public function getWarningUnits()
    {
        return $this->WarningUnits;
    }
    /**
     * Set WarningUnits value
     * @param int $warningUnits
     * @return \StructType\AccountSkuDetails
     */
    public function setWarningUnits($warningUnits = null)
    {
        // validation for constraint: int
        if (!is_null($warningUnits) && !is_numeric($warningUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warningUnits)), __LINE__);
        }
        $this->WarningUnits = $warningUnits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountSkuDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
