<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RemoveAdministrativeUnit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveAdministrativeUnit $parameters
     * @return \StructType\RemoveAdministrativeUnitResponse|bool
     */
    public function RemoveAdministrativeUnit(\StructType\RemoveAdministrativeUnit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveAdministrativeUnit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveAdministrativeUnitMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveAdministrativeUnitMembers $parameters
     * @return \StructType\RemoveAdministrativeUnitMembersResponse|bool
     */
    public function RemoveAdministrativeUnitMembers(\StructType\RemoveAdministrativeUnitMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveAdministrativeUnitMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveContact $parameters
     * @return \StructType\RemoveContactResponse|bool
     */
    public function RemoveContact(\StructType\RemoveContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveDomain $parameters
     * @return \StructType\RemoveDomainResponse|bool
     */
    public function RemoveDomain(\StructType\RemoveDomain $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveDomain($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveGroup $parameters
     * @return \StructType\RemoveGroupResponse|bool
     */
    public function RemoveGroup(\StructType\RemoveGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveGroupMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveGroupMembers $parameters
     * @return \StructType\RemoveGroupMembersResponse|bool
     */
    public function RemoveGroupMembers(\StructType\RemoveGroupMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveGroupMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveRoleMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveRoleMembers $parameters
     * @return \StructType\RemoveRoleMembersResponse|bool
     */
    public function RemoveRoleMembers(\StructType\RemoveRoleMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveRoleMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveRoleMembersByRoleName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveRoleMembersByRoleName $parameters
     * @return \StructType\RemoveRoleMembersByRoleNameResponse|bool
     */
    public function RemoveRoleMembersByRoleName(\StructType\RemoveRoleMembersByRoleName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveRoleMembersByRoleName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveForeignGroupFromRole
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveForeignGroupFromRole $parameters
     * @return \StructType\RemoveForeignGroupFromRoleResponse|bool
     */
    public function RemoveForeignGroupFromRole(\StructType\RemoveForeignGroupFromRole $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveForeignGroupFromRole($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveRoleScopedMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveRoleScopedMembers $parameters
     * @return \StructType\RemoveRoleScopedMembersResponse|bool
     */
    public function RemoveRoleScopedMembers(\StructType\RemoveRoleScopedMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveRoleScopedMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveUser $parameters
     * @return \StructType\RemoveUserResponse|bool
     */
    public function RemoveUser(\StructType\RemoveUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveUserByUpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveUserByUpn $parameters
     * @return \StructType\RemoveUserByUpnResponse|bool
     */
    public function RemoveUserByUpn(\StructType\RemoveUserByUpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveUserByUpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveServicePrincipal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveServicePrincipal $parameters
     * @return \StructType\RemoveServicePrincipalResponse|bool
     */
    public function RemoveServicePrincipal(\StructType\RemoveServicePrincipal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveServicePrincipal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RemoveServicePrincipalByAppPrincipalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveServicePrincipalByAppPrincipalId $parameters
     * @return \StructType\RemoveServicePrincipalByAppPrincipalIdResponse|bool
     */
    public function RemoveServicePrincipalByAppPrincipalId(\StructType\RemoveServicePrincipalByAppPrincipalId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveServicePrincipalByAppPrincipalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveServicePrincipalBySpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveServicePrincipalBySpn $parameters
     * @return \StructType\RemoveServicePrincipalBySpnResponse|bool
     */
    public function RemoveServicePrincipalBySpn(\StructType\RemoveServicePrincipalBySpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveServicePrincipalBySpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveServicePrincipalCredentials
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveServicePrincipalCredentials $parameters
     * @return \StructType\RemoveServicePrincipalCredentialsResponse|bool
     */
    public function RemoveServicePrincipalCredentials(\StructType\RemoveServicePrincipalCredentials $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveServicePrincipalCredentials($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RemoveServicePrincipalCredentialsBySpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveServicePrincipalCredentialsBySpn $parameters
     * @return \StructType\RemoveServicePrincipalCredentialsBySpnResponse|bool
     */
    public function RemoveServicePrincipalCredentialsBySpn(\StructType\RemoveServicePrincipalCredentialsBySpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveServicePrincipalCredentialsBySpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RemoveServicePrincipalCredentialsByAppPrincipalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveServicePrincipalCredentialsByAppPrincipalId $parameters
     * @return \StructType\RemoveServicePrincipalCredentialsByAppPrincipalIdResponse|bool
     */
    public function RemoveServicePrincipalCredentialsByAppPrincipalId(\StructType\RemoveServicePrincipalCredentialsByAppPrincipalId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveServicePrincipalCredentialsByAppPrincipalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveAdministrativeUnitMembersResponse|\StructType\RemoveAdministrativeUnitResponse|\StructType\RemoveContactResponse|\StructType\RemoveDomainResponse|\StructType\RemoveForeignGroupFromRoleResponse|\StructType\RemoveGroupMembersResponse|\StructType\RemoveGroupResponse|\StructType\RemoveRoleMembersByRoleNameResponse|\StructType\RemoveRoleMembersResponse|\StructType\RemoveRoleScopedMembersResponse|\StructType\RemoveServicePrincipalByAppPrincipalIdResponse|\StructType\RemoveServicePrincipalBySpnResponse|\StructType\RemoveServicePrincipalCredentialsByAppPrincipalIdResponse|\StructType\RemoveServicePrincipalCredentialsBySpnResponse|\StructType\RemoveServicePrincipalCredentialsResponse|\StructType\RemoveServicePrincipalResponse|\StructType\RemoveUserByUpnResponse|\StructType\RemoveUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
