<?php

namespace EnumType;

/**
 * This class stands for SortField EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SortField
 * @subpackage Enumerations
 */
class SortField
{
    /**
     * Constant for value 'DisplayName'
     * @return string 'DisplayName'
     */
    const VALUE_DISPLAY_NAME = 'DisplayName';
    /**
     * Constant for value 'UserPrincipalName'
     * @return string 'UserPrincipalName'
     */
    const VALUE_USER_PRINCIPAL_NAME = 'UserPrincipalName';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISPLAY_NAME
     * @uses self::VALUE_USER_PRINCIPAL_NAME
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISPLAY_NAME,
            self::VALUE_USER_PRINCIPAL_NAME,
            self::VALUE_NONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
