<?php

namespace EnumType;

/**
 * This class stands for HttpStatusCode EnumType
 * @subpackage Enumerations
 */
class HttpStatusCode
{
    /**
     * Constant for value 'Continue'
     * @return string 'Continue'
     */
    const VALUE_CONTINUE = 'Continue';
    /**
     * Constant for value 'SwitchingProtocols'
     * @return string 'SwitchingProtocols'
     */
    const VALUE_SWITCHING_PROTOCOLS = 'SwitchingProtocols';
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'Created'
     * @return string 'Created'
     */
    const VALUE_CREATED = 'Created';
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'NonAuthoritativeInformation'
     * @return string 'NonAuthoritativeInformation'
     */
    const VALUE_NON_AUTHORITATIVE_INFORMATION = 'NonAuthoritativeInformation';
    /**
     * Constant for value 'NoContent'
     * @return string 'NoContent'
     */
    const VALUE_NO_CONTENT = 'NoContent';
    /**
     * Constant for value 'ResetContent'
     * @return string 'ResetContent'
     */
    const VALUE_RESET_CONTENT = 'ResetContent';
    /**
     * Constant for value 'PartialContent'
     * @return string 'PartialContent'
     */
    const VALUE_PARTIAL_CONTENT = 'PartialContent';
    /**
     * Constant for value 'MultipleChoices'
     * @return string 'MultipleChoices'
     */
    const VALUE_MULTIPLE_CHOICES = 'MultipleChoices';
    /**
     * Constant for value 'Ambiguous'
     * @return string 'Ambiguous'
     */
    const VALUE_AMBIGUOUS = 'Ambiguous';
    /**
     * Constant for value 'MovedPermanently'
     * @return string 'MovedPermanently'
     */
    const VALUE_MOVED_PERMANENTLY = 'MovedPermanently';
    /**
     * Constant for value 'Moved'
     * @return string 'Moved'
     */
    const VALUE_MOVED = 'Moved';
    /**
     * Constant for value 'Found'
     * @return string 'Found'
     */
    const VALUE_FOUND = 'Found';
    /**
     * Constant for value 'Redirect'
     * @return string 'Redirect'
     */
    const VALUE_REDIRECT = 'Redirect';
    /**
     * Constant for value 'SeeOther'
     * @return string 'SeeOther'
     */
    const VALUE_SEE_OTHER = 'SeeOther';
    /**
     * Constant for value 'RedirectMethod'
     * @return string 'RedirectMethod'
     */
    const VALUE_REDIRECT_METHOD = 'RedirectMethod';
    /**
     * Constant for value 'NotModified'
     * @return string 'NotModified'
     */
    const VALUE_NOT_MODIFIED = 'NotModified';
    /**
     * Constant for value 'UseProxy'
     * @return string 'UseProxy'
     */
    const VALUE_USE_PROXY = 'UseProxy';
    /**
     * Constant for value 'Unused'
     * @return string 'Unused'
     */
    const VALUE_UNUSED = 'Unused';
    /**
     * Constant for value 'TemporaryRedirect'
     * @return string 'TemporaryRedirect'
     */
    const VALUE_TEMPORARY_REDIRECT = 'TemporaryRedirect';
    /**
     * Constant for value 'RedirectKeepVerb'
     * @return string 'RedirectKeepVerb'
     */
    const VALUE_REDIRECT_KEEP_VERB = 'RedirectKeepVerb';
    /**
     * Constant for value 'BadRequest'
     * @return string 'BadRequest'
     */
    const VALUE_BAD_REQUEST = 'BadRequest';
    /**
     * Constant for value 'Unauthorized'
     * @return string 'Unauthorized'
     */
    const VALUE_UNAUTHORIZED = 'Unauthorized';
    /**
     * Constant for value 'PaymentRequired'
     * @return string 'PaymentRequired'
     */
    const VALUE_PAYMENT_REQUIRED = 'PaymentRequired';
    /**
     * Constant for value 'Forbidden'
     * @return string 'Forbidden'
     */
    const VALUE_FORBIDDEN = 'Forbidden';
    /**
     * Constant for value 'NotFound'
     * @return string 'NotFound'
     */
    const VALUE_NOT_FOUND = 'NotFound';
    /**
     * Constant for value 'MethodNotAllowed'
     * @return string 'MethodNotAllowed'
     */
    const VALUE_METHOD_NOT_ALLOWED = 'MethodNotAllowed';
    /**
     * Constant for value 'NotAcceptable'
     * @return string 'NotAcceptable'
     */
    const VALUE_NOT_ACCEPTABLE = 'NotAcceptable';
    /**
     * Constant for value 'ProxyAuthenticationRequired'
     * @return string 'ProxyAuthenticationRequired'
     */
    const VALUE_PROXY_AUTHENTICATION_REQUIRED = 'ProxyAuthenticationRequired';
    /**
     * Constant for value 'RequestTimeout'
     * @return string 'RequestTimeout'
     */
    const VALUE_REQUEST_TIMEOUT = 'RequestTimeout';
    /**
     * Constant for value 'Conflict'
     * @return string 'Conflict'
     */
    const VALUE_CONFLICT = 'Conflict';
    /**
     * Constant for value 'Gone'
     * @return string 'Gone'
     */
    const VALUE_GONE = 'Gone';
    /**
     * Constant for value 'LengthRequired'
     * @return string 'LengthRequired'
     */
    const VALUE_LENGTH_REQUIRED = 'LengthRequired';
    /**
     * Constant for value 'PreconditionFailed'
     * @return string 'PreconditionFailed'
     */
    const VALUE_PRECONDITION_FAILED = 'PreconditionFailed';
    /**
     * Constant for value 'RequestEntityTooLarge'
     * @return string 'RequestEntityTooLarge'
     */
    const VALUE_REQUEST_ENTITY_TOO_LARGE = 'RequestEntityTooLarge';
    /**
     * Constant for value 'RequestUriTooLong'
     * @return string 'RequestUriTooLong'
     */
    const VALUE_REQUEST_URI_TOO_LONG = 'RequestUriTooLong';
    /**
     * Constant for value 'UnsupportedMediaType'
     * @return string 'UnsupportedMediaType'
     */
    const VALUE_UNSUPPORTED_MEDIA_TYPE = 'UnsupportedMediaType';
    /**
     * Constant for value 'RequestedRangeNotSatisfiable'
     * @return string 'RequestedRangeNotSatisfiable'
     */
    const VALUE_REQUESTED_RANGE_NOT_SATISFIABLE = 'RequestedRangeNotSatisfiable';
    /**
     * Constant for value 'ExpectationFailed'
     * @return string 'ExpectationFailed'
     */
    const VALUE_EXPECTATION_FAILED = 'ExpectationFailed';
    /**
     * Constant for value 'UpgradeRequired'
     * @return string 'UpgradeRequired'
     */
    const VALUE_UPGRADE_REQUIRED = 'UpgradeRequired';
    /**
     * Constant for value 'InternalServerError'
     * @return string 'InternalServerError'
     */
    const VALUE_INTERNAL_SERVER_ERROR = 'InternalServerError';
    /**
     * Constant for value 'NotImplemented'
     * @return string 'NotImplemented'
     */
    const VALUE_NOT_IMPLEMENTED = 'NotImplemented';
    /**
     * Constant for value 'BadGateway'
     * @return string 'BadGateway'
     */
    const VALUE_BAD_GATEWAY = 'BadGateway';
    /**
     * Constant for value 'ServiceUnavailable'
     * @return string 'ServiceUnavailable'
     */
    const VALUE_SERVICE_UNAVAILABLE = 'ServiceUnavailable';
    /**
     * Constant for value 'GatewayTimeout'
     * @return string 'GatewayTimeout'
     */
    const VALUE_GATEWAY_TIMEOUT = 'GatewayTimeout';
    /**
     * Constant for value 'HttpVersionNotSupported'
     * @return string 'HttpVersionNotSupported'
     */
    const VALUE_HTTP_VERSION_NOT_SUPPORTED = 'HttpVersionNotSupported';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTINUE
     * @uses self::VALUE_SWITCHING_PROTOCOLS
     * @uses self::VALUE_OK
     * @uses self::VALUE_CREATED
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_NON_AUTHORITATIVE_INFORMATION
     * @uses self::VALUE_NO_CONTENT
     * @uses self::VALUE_RESET_CONTENT
     * @uses self::VALUE_PARTIAL_CONTENT
     * @uses self::VALUE_MULTIPLE_CHOICES
     * @uses self::VALUE_AMBIGUOUS
     * @uses self::VALUE_MOVED_PERMANENTLY
     * @uses self::VALUE_MOVED
     * @uses self::VALUE_FOUND
     * @uses self::VALUE_REDIRECT
     * @uses self::VALUE_SEE_OTHER
     * @uses self::VALUE_REDIRECT_METHOD
     * @uses self::VALUE_NOT_MODIFIED
     * @uses self::VALUE_USE_PROXY
     * @uses self::VALUE_UNUSED
     * @uses self::VALUE_TEMPORARY_REDIRECT
     * @uses self::VALUE_REDIRECT_KEEP_VERB
     * @uses self::VALUE_BAD_REQUEST
     * @uses self::VALUE_UNAUTHORIZED
     * @uses self::VALUE_PAYMENT_REQUIRED
     * @uses self::VALUE_FORBIDDEN
     * @uses self::VALUE_NOT_FOUND
     * @uses self::VALUE_METHOD_NOT_ALLOWED
     * @uses self::VALUE_NOT_ACCEPTABLE
     * @uses self::VALUE_PROXY_AUTHENTICATION_REQUIRED
     * @uses self::VALUE_REQUEST_TIMEOUT
     * @uses self::VALUE_CONFLICT
     * @uses self::VALUE_GONE
     * @uses self::VALUE_LENGTH_REQUIRED
     * @uses self::VALUE_PRECONDITION_FAILED
     * @uses self::VALUE_REQUEST_ENTITY_TOO_LARGE
     * @uses self::VALUE_REQUEST_URI_TOO_LONG
     * @uses self::VALUE_UNSUPPORTED_MEDIA_TYPE
     * @uses self::VALUE_REQUESTED_RANGE_NOT_SATISFIABLE
     * @uses self::VALUE_EXPECTATION_FAILED
     * @uses self::VALUE_UPGRADE_REQUIRED
     * @uses self::VALUE_INTERNAL_SERVER_ERROR
     * @uses self::VALUE_NOT_IMPLEMENTED
     * @uses self::VALUE_BAD_GATEWAY
     * @uses self::VALUE_SERVICE_UNAVAILABLE
     * @uses self::VALUE_GATEWAY_TIMEOUT
     * @uses self::VALUE_HTTP_VERSION_NOT_SUPPORTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTINUE,
            self::VALUE_SWITCHING_PROTOCOLS,
            self::VALUE_OK,
            self::VALUE_CREATED,
            self::VALUE_ACCEPTED,
            self::VALUE_NON_AUTHORITATIVE_INFORMATION,
            self::VALUE_NO_CONTENT,
            self::VALUE_RESET_CONTENT,
            self::VALUE_PARTIAL_CONTENT,
            self::VALUE_MULTIPLE_CHOICES,
            self::VALUE_AMBIGUOUS,
            self::VALUE_MOVED_PERMANENTLY,
            self::VALUE_MOVED,
            self::VALUE_FOUND,
            self::VALUE_REDIRECT,
            self::VALUE_SEE_OTHER,
            self::VALUE_REDIRECT_METHOD,
            self::VALUE_NOT_MODIFIED,
            self::VALUE_USE_PROXY,
            self::VALUE_UNUSED,
            self::VALUE_TEMPORARY_REDIRECT,
            self::VALUE_REDIRECT_KEEP_VERB,
            self::VALUE_BAD_REQUEST,
            self::VALUE_UNAUTHORIZED,
            self::VALUE_PAYMENT_REQUIRED,
            self::VALUE_FORBIDDEN,
            self::VALUE_NOT_FOUND,
            self::VALUE_METHOD_NOT_ALLOWED,
            self::VALUE_NOT_ACCEPTABLE,
            self::VALUE_PROXY_AUTHENTICATION_REQUIRED,
            self::VALUE_REQUEST_TIMEOUT,
            self::VALUE_CONFLICT,
            self::VALUE_GONE,
            self::VALUE_LENGTH_REQUIRED,
            self::VALUE_PRECONDITION_FAILED,
            self::VALUE_REQUEST_ENTITY_TOO_LARGE,
            self::VALUE_REQUEST_URI_TOO_LONG,
            self::VALUE_UNSUPPORTED_MEDIA_TYPE,
            self::VALUE_REQUESTED_RANGE_NOT_SATISFIABLE,
            self::VALUE_EXPECTATION_FAILED,
            self::VALUE_UPGRADE_REQUIRED,
            self::VALUE_INTERNAL_SERVER_ERROR,
            self::VALUE_NOT_IMPLEMENTED,
            self::VALUE_BAD_GATEWAY,
            self::VALUE_SERVICE_UNAVAILABLE,
            self::VALUE_GATEWAY_TIMEOUT,
            self::VALUE_HTTP_VERSION_NOT_SUPPORTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
