<?php

namespace EnumType;

/**
 * This class stands for DomainVerificationMethod EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainVerificationMethod
 * @subpackage Enumerations
 */
class DomainVerificationMethod
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'DnsRecord'
     * @return string 'DnsRecord'
     */
    const VALUE_DNS_RECORD = 'DnsRecord';
    /**
     * Constant for value 'Email'
     * @return string 'Email'
     */
    const VALUE_EMAIL = 'Email';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_DNS_RECORD
     * @uses self::VALUE_EMAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_DNS_RECORD,
            self::VALUE_EMAIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
