<?php

namespace EnumType;

/**
 * This class stands for DomainCapabilities EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainCapabilities
 * @subpackage Enumerations
 */
class DomainCapabilities
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Email'
     * @return string 'Email'
     */
    const VALUE_EMAIL = 'Email';
    /**
     * Constant for value 'Sharepoint'
     * @return string 'Sharepoint'
     */
    const VALUE_SHAREPOINT = 'Sharepoint';
    /**
     * Constant for value 'OfficeCommunicationsOnline'
     * @return string 'OfficeCommunicationsOnline'
     */
    const VALUE_OFFICE_COMMUNICATIONS_ONLINE = 'OfficeCommunicationsOnline';
    /**
     * Constant for value 'SharepointDefault'
     * @return string 'SharepointDefault'
     */
    const VALUE_SHAREPOINT_DEFAULT = 'SharepointDefault';
    /**
     * Constant for value 'FullRedelegation'
     * @return string 'FullRedelegation'
     */
    const VALUE_FULL_REDELEGATION = 'FullRedelegation';
    /**
     * Constant for value 'SharePointPublic'
     * @return string 'SharePointPublic'
     */
    const VALUE_SHARE_POINT_PUBLIC = 'SharePointPublic';
    /**
     * Constant for value 'OrgIdAuthentication'
     * @return string 'OrgIdAuthentication'
     */
    const VALUE_ORG_ID_AUTHENTICATION = 'OrgIdAuthentication';
    /**
     * Constant for value 'Yammer'
     * @return string 'Yammer'
     */
    const VALUE_YAMMER = 'Yammer';
    /**
     * Constant for value 'Intune'
     * @return string 'Intune'
     */
    const VALUE_INTUNE = 'Intune';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_SHAREPOINT
     * @uses self::VALUE_OFFICE_COMMUNICATIONS_ONLINE
     * @uses self::VALUE_SHAREPOINT_DEFAULT
     * @uses self::VALUE_FULL_REDELEGATION
     * @uses self::VALUE_SHARE_POINT_PUBLIC
     * @uses self::VALUE_ORG_ID_AUTHENTICATION
     * @uses self::VALUE_YAMMER
     * @uses self::VALUE_INTUNE
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_EMAIL,
            self::VALUE_SHAREPOINT,
            self::VALUE_OFFICE_COMMUNICATIONS_ONLINE,
            self::VALUE_SHAREPOINT_DEFAULT,
            self::VALUE_FULL_REDELEGATION,
            self::VALUE_SHARE_POINT_PUBLIC,
            self::VALUE_ORG_ID_AUTHENTICATION,
            self::VALUE_YAMMER,
            self::VALUE_INTUNE,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
