<?php

namespace EnumType;

/**
 * This class stands for DomainAvailability EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainAvailability
 * @subpackage Enumerations
 */
class DomainAvailability
{
    /**
     * Constant for value 'AvailableImmediately'
     * @return string 'AvailableImmediately'
     */
    const VALUE_AVAILABLE_IMMEDIATELY = 'AvailableImmediately';
    /**
     * Constant for value 'TakeoverScheduled'
     * @return string 'TakeoverScheduled'
     */
    const VALUE_TAKEOVER_SCHEDULED = 'TakeoverScheduled';
    /**
     * Constant for value 'EmailVerifiedDomainTakeoverScheduled'
     * @return string 'EmailVerifiedDomainTakeoverScheduled'
     */
    const VALUE_EMAIL_VERIFIED_DOMAIN_TAKEOVER_SCHEDULED = 'EmailVerifiedDomainTakeoverScheduled';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVAILABLE_IMMEDIATELY
     * @uses self::VALUE_TAKEOVER_SCHEDULED
     * @uses self::VALUE_EMAIL_VERIFIED_DOMAIN_TAKEOVER_SCHEDULED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVAILABLE_IMMEDIATELY,
            self::VALUE_TAKEOVER_SCHEDULED,
            self::VALUE_EMAIL_VERIFIED_DOMAIN_TAKEOVER_SCHEDULED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
