<?php

namespace EnumType;

/**
 * This class stands for DomainAuthenticationType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainAuthenticationType
 * @subpackage Enumerations
 */
class DomainAuthenticationType
{
    /**
     * Constant for value 'Managed'
     * @return string 'Managed'
     */
    const VALUE_MANAGED = 'Managed';
    /**
     * Constant for value 'Federated'
     * @return string 'Federated'
     */
    const VALUE_FEDERATED = 'Federated';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MANAGED
     * @uses self::VALUE_FEDERATED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MANAGED,
            self::VALUE_FEDERATED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
