<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStrongAuthenticationMethod ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStrongAuthenticationMethod
 * @subpackage Arrays
 */
class ArrayOfStrongAuthenticationMethod extends AbstractStructArrayBase
{
    /**
     * The StrongAuthenticationMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StrongAuthenticationMethod[]
     */
    public $StrongAuthenticationMethod;
    /**
     * Constructor method for ArrayOfStrongAuthenticationMethod
     * @uses ArrayOfStrongAuthenticationMethod::setStrongAuthenticationMethod()
     * @param \StructType\StrongAuthenticationMethod[] $strongAuthenticationMethod
     */
    public function __construct(array $strongAuthenticationMethod = array())
    {
        $this
            ->setStrongAuthenticationMethod($strongAuthenticationMethod);
    }
    /**
     * Get StrongAuthenticationMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StrongAuthenticationMethod[]|null
     */
    public function getStrongAuthenticationMethod()
    {
        return isset($this->StrongAuthenticationMethod) ? $this->StrongAuthenticationMethod : null;
    }
    /**
     * Set StrongAuthenticationMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StrongAuthenticationMethod[] $strongAuthenticationMethod
     * @return \ArrayType\ArrayOfStrongAuthenticationMethod
     */
    public function setStrongAuthenticationMethod(array $strongAuthenticationMethod = array())
    {
        foreach ($strongAuthenticationMethod as $arrayOfStrongAuthenticationMethodStrongAuthenticationMethodItem) {
            // validation for constraint: itemType
            if (!$arrayOfStrongAuthenticationMethodStrongAuthenticationMethodItem instanceof \StructType\StrongAuthenticationMethod) {
                throw new \InvalidArgumentException(sprintf('The StrongAuthenticationMethod property can only contain items of \StructType\StrongAuthenticationMethod, "%s" given', is_object($arrayOfStrongAuthenticationMethodStrongAuthenticationMethodItem) ? get_class($arrayOfStrongAuthenticationMethodStrongAuthenticationMethodItem) : gettype($arrayOfStrongAuthenticationMethodStrongAuthenticationMethodItem)), __LINE__);
            }
        }
        if (is_null($strongAuthenticationMethod) || (is_array($strongAuthenticationMethod) && empty($strongAuthenticationMethod))) {
            unset($this->StrongAuthenticationMethod);
        } else {
            $this->StrongAuthenticationMethod = $strongAuthenticationMethod;
        }
        return $this;
    }
    /**
     * Add item to StrongAuthenticationMethod value
     * @throws \InvalidArgumentException
     * @param \StructType\StrongAuthenticationMethod $item
     * @return \ArrayType\ArrayOfStrongAuthenticationMethod
     */
    public function addToStrongAuthenticationMethod(\StructType\StrongAuthenticationMethod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StrongAuthenticationMethod) {
            throw new \InvalidArgumentException(sprintf('The StrongAuthenticationMethod property can only contain items of \StructType\StrongAuthenticationMethod, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StrongAuthenticationMethod[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\StrongAuthenticationMethod|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\StrongAuthenticationMethod|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\StrongAuthenticationMethod|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\StrongAuthenticationMethod|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\StrongAuthenticationMethod|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StrongAuthenticationMethod
     */
    public function getAttributeName()
    {
        return 'StrongAuthenticationMethod';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStrongAuthenticationMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
