<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceInformation ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfServiceInformation
 * @subpackage Arrays
 */
class ArrayOfServiceInformation extends AbstractStructArrayBase
{
    /**
     * The ServiceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceInformation[]
     */
    public $ServiceInformation;
    /**
     * Constructor method for ArrayOfServiceInformation
     * @uses ArrayOfServiceInformation::setServiceInformation()
     * @param \StructType\ServiceInformation[] $serviceInformation
     */
    public function __construct(array $serviceInformation = array())
    {
        $this
            ->setServiceInformation($serviceInformation);
    }
    /**
     * Get ServiceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceInformation[]|null
     */
    public function getServiceInformation()
    {
        return isset($this->ServiceInformation) ? $this->ServiceInformation : null;
    }
    /**
     * Set ServiceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceInformation[] $serviceInformation
     * @return \ArrayType\ArrayOfServiceInformation
     */
    public function setServiceInformation(array $serviceInformation = array())
    {
        foreach ($serviceInformation as $arrayOfServiceInformationServiceInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceInformationServiceInformationItem instanceof \StructType\ServiceInformation) {
                throw new \InvalidArgumentException(sprintf('The ServiceInformation property can only contain items of \StructType\ServiceInformation, "%s" given', is_object($arrayOfServiceInformationServiceInformationItem) ? get_class($arrayOfServiceInformationServiceInformationItem) : gettype($arrayOfServiceInformationServiceInformationItem)), __LINE__);
            }
        }
        if (is_null($serviceInformation) || (is_array($serviceInformation) && empty($serviceInformation))) {
            unset($this->ServiceInformation);
        } else {
            $this->ServiceInformation = $serviceInformation;
        }
        return $this;
    }
    /**
     * Add item to ServiceInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceInformation $item
     * @return \ArrayType\ArrayOfServiceInformation
     */
    public function addToServiceInformation(\StructType\ServiceInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceInformation) {
            throw new \InvalidArgumentException(sprintf('The ServiceInformation property can only contain items of \StructType\ServiceInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceInformation
     */
    public function getAttributeName()
    {
        return 'ServiceInformation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfServiceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
