<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoleMember ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRoleMember
 * @subpackage Arrays
 */
class ArrayOfRoleMember extends AbstractStructArrayBase
{
    /**
     * The RoleMember
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoleMember[]
     */
    public $RoleMember;
    /**
     * Constructor method for ArrayOfRoleMember
     * @uses ArrayOfRoleMember::setRoleMember()
     * @param \StructType\RoleMember[] $roleMember
     */
    public function __construct(array $roleMember = array())
    {
        $this
            ->setRoleMember($roleMember);
    }
    /**
     * Get RoleMember value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoleMember[]|null
     */
    public function getRoleMember()
    {
        return isset($this->RoleMember) ? $this->RoleMember : null;
    }
    /**
     * Set RoleMember value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoleMember[] $roleMember
     * @return \ArrayType\ArrayOfRoleMember
     */
    public function setRoleMember(array $roleMember = array())
    {
        foreach ($roleMember as $arrayOfRoleMemberRoleMemberItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoleMemberRoleMemberItem instanceof \StructType\RoleMember) {
                throw new \InvalidArgumentException(sprintf('The RoleMember property can only contain items of \StructType\RoleMember, "%s" given', is_object($arrayOfRoleMemberRoleMemberItem) ? get_class($arrayOfRoleMemberRoleMemberItem) : gettype($arrayOfRoleMemberRoleMemberItem)), __LINE__);
            }
        }
        if (is_null($roleMember) || (is_array($roleMember) && empty($roleMember))) {
            unset($this->RoleMember);
        } else {
            $this->RoleMember = $roleMember;
        }
        return $this;
    }
    /**
     * Add item to RoleMember value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleMember $item
     * @return \ArrayType\ArrayOfRoleMember
     */
    public function addToRoleMember(\StructType\RoleMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoleMember) {
            throw new \InvalidArgumentException(sprintf('The RoleMember property can only contain items of \StructType\RoleMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoleMember[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoleMember|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoleMember|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoleMember|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoleMember|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoleMember|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoleMember
     */
    public function getAttributeName()
    {
        return 'RoleMember';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoleMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
