<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrackingHeader
 * @subpackage Structs
 */
class TrackingHeader extends AbstractStructBase
{
    /**
     * The CorrelationId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CorrelationId;
    /**
     * Constructor method for TrackingHeader
     * @uses TrackingHeader::setCorrelationId()
     * @param string $correlationId
     */
    public function __construct($correlationId = null)
    {
        $this
            ->setCorrelationId($correlationId);
    }
    /**
     * Get CorrelationId value
     * @return string|null
     */
    public function getCorrelationId()
    {
        return $this->CorrelationId;
    }
    /**
     * Set CorrelationId value
     * @param string $correlationId
     * @return \StructType\TrackingHeader
     */
    public function setCorrelationId($correlationId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($correlationId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($correlationId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($correlationId) && !is_string($correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($correlationId)), __LINE__);
        }
        $this->CorrelationId = $correlationId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrackingHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
