<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StringLengthValidationException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StringLengthValidationException
 * @subpackage Structs
 */
class StringLengthValidationException extends PropertyValidationException
{
    /**
     * The MaxLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxLength;
    /**
     * The MinLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinLength;
    /**
     * Constructor method for StringLengthValidationException
     * @uses StringLengthValidationException::setMaxLength()
     * @uses StringLengthValidationException::setMinLength()
     * @param int $maxLength
     * @param int $minLength
     */
    public function __construct($maxLength = null, $minLength = null)
    {
        $this
            ->setMaxLength($maxLength)
            ->setMinLength($minLength);
    }
    /**
     * Get MaxLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxLength()
    {
        return isset($this->MaxLength) ? $this->MaxLength : null;
    }
    /**
     * Set MaxLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxLength
     * @return \StructType\StringLengthValidationException
     */
    public function setMaxLength($maxLength = null)
    {
        // validation for constraint: int
        if (!is_null($maxLength) && !is_numeric($maxLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxLength)), __LINE__);
        }
        if (is_null($maxLength) || (is_array($maxLength) && empty($maxLength))) {
            unset($this->MaxLength);
        } else {
            $this->MaxLength = $maxLength;
        }
        return $this;
    }
    /**
     * Get MinLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinLength()
    {
        return isset($this->MinLength) ? $this->MinLength : null;
    }
    /**
     * Set MinLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minLength
     * @return \StructType\StringLengthValidationException
     */
    public function setMinLength($minLength = null)
    {
        // validation for constraint: int
        if (!is_null($minLength) && !is_numeric($minLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minLength)), __LINE__);
        }
        if (is_null($minLength) || (is_array($minLength) && empty($minLength))) {
            unset($this->MinLength);
        } else {
            $this->MinLength = $minLength;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StringLengthValidationException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
