<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetUserLicensesRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SetUserLicensesRequest
 * @subpackage Structs
 */
class SetUserLicensesRequest extends Request
{
    /**
     * The AddLicenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountSkuIdentifier
     */
    public $AddLicenses;
    /**
     * The LicenseOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLicenseOption
     */
    public $LicenseOptions;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The RemoveLicenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountSkuIdentifier
     */
    public $RemoveLicenses;
    /**
     * Constructor method for SetUserLicensesRequest
     * @uses SetUserLicensesRequest::setAddLicenses()
     * @uses SetUserLicensesRequest::setLicenseOptions()
     * @uses SetUserLicensesRequest::setObjectId()
     * @uses SetUserLicensesRequest::setRemoveLicenses()
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $addLicenses
     * @param \ArrayType\ArrayOfLicenseOption $licenseOptions
     * @param string $objectId
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $removeLicenses
     */
    public function __construct(\ArrayType\ArrayOfAccountSkuIdentifier $addLicenses = null, \ArrayType\ArrayOfLicenseOption $licenseOptions = null, $objectId = null, \ArrayType\ArrayOfAccountSkuIdentifier $removeLicenses = null)
    {
        $this
            ->setAddLicenses($addLicenses)
            ->setLicenseOptions($licenseOptions)
            ->setObjectId($objectId)
            ->setRemoveLicenses($removeLicenses);
    }
    /**
     * Get AddLicenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountSkuIdentifier|null
     */
    public function getAddLicenses()
    {
        return isset($this->AddLicenses) ? $this->AddLicenses : null;
    }
    /**
     * Set AddLicenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $addLicenses
     * @return \StructType\SetUserLicensesRequest
     */
    public function setAddLicenses(\ArrayType\ArrayOfAccountSkuIdentifier $addLicenses = null)
    {
        if (is_null($addLicenses) || (is_array($addLicenses) && empty($addLicenses))) {
            unset($this->AddLicenses);
        } else {
            $this->AddLicenses = $addLicenses;
        }
        return $this;
    }
    /**
     * Get LicenseOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLicenseOption|null
     */
    public function getLicenseOptions()
    {
        return isset($this->LicenseOptions) ? $this->LicenseOptions : null;
    }
    /**
     * Set LicenseOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLicenseOption $licenseOptions
     * @return \StructType\SetUserLicensesRequest
     */
    public function setLicenseOptions(\ArrayType\ArrayOfLicenseOption $licenseOptions = null)
    {
        if (is_null($licenseOptions) || (is_array($licenseOptions) && empty($licenseOptions))) {
            unset($this->LicenseOptions);
        } else {
            $this->LicenseOptions = $licenseOptions;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \StructType\SetUserLicensesRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get RemoveLicenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountSkuIdentifier|null
     */
    public function getRemoveLicenses()
    {
        return isset($this->RemoveLicenses) ? $this->RemoveLicenses : null;
    }
    /**
     * Set RemoveLicenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $removeLicenses
     * @return \StructType\SetUserLicensesRequest
     */
    public function setRemoveLicenses(\ArrayType\ArrayOfAccountSkuIdentifier $removeLicenses = null)
    {
        if (is_null($removeLicenses) || (is_array($removeLicenses) && empty($removeLicenses))) {
            unset($this->RemoveLicenses);
        } else {
            $this->RemoveLicenses = $removeLicenses;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetUserLicensesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
