<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceInformation
 * @subpackage Structs
 */
class ServiceInformation extends AbstractStructBase
{
    /**
     * The ServiceElements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfXElement
     */
    public $ServiceElements;
    /**
     * The ServiceInstance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceInstance;
    /**
     * Constructor method for ServiceInformation
     * @uses ServiceInformation::setServiceElements()
     * @uses ServiceInformation::setServiceInstance()
     * @param \ArrayType\ArrayOfXElement $serviceElements
     * @param string $serviceInstance
     */
    public function __construct(\ArrayType\ArrayOfXElement $serviceElements = null, $serviceInstance = null)
    {
        $this
            ->setServiceElements($serviceElements)
            ->setServiceInstance($serviceInstance);
    }
    /**
     * Get ServiceElements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfXElement|null
     */
    public function getServiceElements()
    {
        return isset($this->ServiceElements) ? $this->ServiceElements : null;
    }
    /**
     * Set ServiceElements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfXElement $serviceElements
     * @return \StructType\ServiceInformation
     */
    public function setServiceElements(\ArrayType\ArrayOfXElement $serviceElements = null)
    {
        if (is_null($serviceElements) || (is_array($serviceElements) && empty($serviceElements))) {
            unset($this->ServiceElements);
        } else {
            $this->ServiceElements = $serviceElements;
        }
        return $this;
    }
    /**
     * Get ServiceInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceInstance()
    {
        return isset($this->ServiceInstance) ? $this->ServiceInstance : null;
    }
    /**
     * Set ServiceInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceInstance
     * @return \StructType\ServiceInformation
     */
    public function setServiceInstance($serviceInstance = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInstance) && !is_string($serviceInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceInstance)), __LINE__);
        }
        if (is_null($serviceInstance) || (is_array($serviceInstance) && empty($serviceInstance))) {
            unset($this->ServiceInstance);
        } else {
            $this->ServiceInstance = $serviceInstance;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
